/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.MinifiedBouncyCastleProvider;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.RDN;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.style.BCStyle;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.style.IETFUtils;
import com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtil.class);
    private static final LoadingCache<X509Certificate, String> commonNameCache = Caffeine.newBuilder().weakKeys().build(cert -> {
        try {
            X500Name x500Name = new JcaX509CertificateHolder((X509Certificate)cert).getSubject();
            RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        catch (Exception e) {
            logger.warn("Failed to get the common name from a certificate: {}", cert, (Object)e);
            return null;
        }
    });

    @Nullable
    public static String getCommonName(SSLSession session) {
        Certificate[] certs = session.getLocalCertificates();
        if (certs == null || certs.length == 0) {
            return null;
        }
        return CertificateUtil.getCommonName(certs[0]);
    }

    @Nullable
    public static String getCommonName(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        return commonNameCache.get((X509Certificate)certificate);
    }

    public static List<X509Certificate> toX509Certificates(File file) throws CertificateException {
        Objects.requireNonNull(file, "file");
        return ImmutableList.copyOf(SslContextProtectedAccessHack.toX509CertificateList(file));
    }

    public static List<X509Certificate> toX509Certificates(InputStream in) throws CertificateException {
        Objects.requireNonNull(in, "in");
        return ImmutableList.copyOf(SslContextProtectedAccessHack.toX509CertificateList(in));
    }

    public static PrivateKey toPrivateKey(File file, @Nullable String keyPassword) throws KeyException {
        Objects.requireNonNull(file, "file");
        return MinifiedBouncyCastleProvider.call(() -> {
            try {
                return SslContextProtectedAccessHack.privateKey(file, keyPassword);
            }
            catch (KeyException e) {
                return (PrivateKey)Exceptions.throwUnsafely(e);
            }
        });
    }

    public static PrivateKey toPrivateKey(InputStream keyInputStream, @Nullable String keyPassword) throws KeyException {
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        return MinifiedBouncyCastleProvider.call(() -> {
            try {
                return SslContextProtectedAccessHack.privateKey(keyInputStream, keyPassword);
            }
            catch (KeyException e) {
                return (PrivateKey)Exceptions.throwUnsafely(e);
            }
        });
    }

    private CertificateUtil() {
    }

    private static final class SslContextProtectedAccessHack
    extends SslContext {
        private SslContextProtectedAccessHack() {
        }

        static X509Certificate[] toX509CertificateList(File file) throws CertificateException {
            return SslContext.toX509Certificates((File)file);
        }

        static X509Certificate[] toX509CertificateList(InputStream in) throws CertificateException {
            return SslContext.toX509Certificates((InputStream)in);
        }

        static PrivateKey privateKey(File file, @Nullable String keyPassword) throws KeyException {
            try {
                return SslContext.toPrivateKey((File)file, (String)keyPassword);
            }
            catch (Exception e) {
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException("Fail to read a private key file: " + file.getName(), e);
            }
        }

        static PrivateKey privateKey(InputStream keyInputStream, @Nullable String keyPassword) throws KeyException {
            try {
                return SslContext.toPrivateKey((InputStream)keyInputStream, (String)keyPassword);
            }
            catch (Exception e) {
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException("Fail to parse a private key", e);
            }
        }

        public boolean isClient() {
            throw new UnsupportedOperationException();
        }

        public List<String> cipherSuites() {
            throw new UnsupportedOperationException();
        }

        public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
            throw new UnsupportedOperationException();
        }

        public SSLEngine newEngine(ByteBufAllocator alloc) {
            throw new UnsupportedOperationException();
        }

        public SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
            throw new UnsupportedOperationException();
        }

        public SSLSessionContext sessionContext() {
            throw new UnsupportedOperationException();
        }
    }
}

