/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectionPoolMetrics
implements SafeCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolMetrics.class);
    private static final ScheduledExecutorService CLEANUP_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ThreadFactories.newThreadFactory("armeria-connection-metric-cleanup-executor", true));
    private static final String PROTOCOL = "protocol";
    private static final String REMOTE_IP = "remote.ip";
    private static final String LOCAL_IP = "local.ip";
    private static final String STATE = "state";
    private final MeterRegistry meterRegistry;
    private final MeterIdPrefix idPrefix;
    @GuardedBy(value="lock")
    private final Map<List<Tag>, Meters> metersMap = new HashMap<List<Tag>, Meters>();
    private final ReentrantShortLock lock = new ReentrantShortLock();
    private final int cleanupDelaySeconds;
    private boolean garbageCollecting;
    private volatile boolean closed;
    private volatile ScheduledFuture<?> scheduledFuture;

    ConnectionPoolMetrics(MeterRegistry meterRegistry, MeterIdPrefix idPrefix) {
        this(meterRegistry, idPrefix, 3600);
    }

    ConnectionPoolMetrics(MeterRegistry meterRegistry, MeterIdPrefix idPrefix, int cleanupDelaySeconds) {
        this.idPrefix = idPrefix;
        this.meterRegistry = meterRegistry;
        this.cleanupDelaySeconds = cleanupDelaySeconds;
        this.scheduledFuture = CLEANUP_EXECUTOR.schedule(this::cleanupInactiveMeters, this.nextCleanupDelaySeconds(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseConnOpened(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        List<Tag> commonTags = this.commonTags(protocol, remoteAddr, localAddr);
        this.lock.lock();
        try {
            Meters meters = this.metersMap.computeIfAbsent(commonTags, x$0 -> new Meters((List<Tag>)x$0));
            meters.increment();
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<Tag> commonTags(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        return this.idPrefix.tags(PROTOCOL, protocol.name(), REMOTE_IP, remoteAddr.getAddress().getHostAddress(), LOCAL_IP, localAddr.getAddress().getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseConnClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        List<Tag> commonTags = this.commonTags(protocol, remoteAddr, localAddr);
        this.lock.lock();
        try {
            Meters meters = this.metersMap.get(commonTags);
            if (meters != null) {
                meters.decrement();
                assert (meters.activeConnections() >= 0) : "active connections should not be negative. " + meters;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupInactiveMeters() {
        ArrayList<Meters> unusedMetersList = new ArrayList<Meters>();
        try {
            this.lock.lock();
            this.garbageCollecting = true;
            try {
                Iterator<Map.Entry<List<Object>, Meters>> it = this.metersMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<List<Tag>, Meters> entry = it.next();
                    Meters meters = entry.getValue();
                    if (meters.activeConnections() != 0) continue;
                    unusedMetersList.add(meters);
                    it.remove();
                }
                if (unusedMetersList.isEmpty()) {
                    this.garbageCollecting = false;
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            for (Meters meters : unusedMetersList) {
                meters.remove(this.meterRegistry);
            }
            this.lock.lock();
            try {
                this.metersMap.values().forEach(Meters::maybeRegisterMetrics);
                this.garbageCollecting = false;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to cleanup inactive meters.", e);
            this.garbageCollecting = false;
        }
        if (this.closed) {
            return;
        }
        this.scheduledFuture = CLEANUP_EXECUTOR.schedule(this::cleanupInactiveMeters, this.nextCleanupDelaySeconds(), TimeUnit.SECONDS);
    }

    private long nextCleanupDelaySeconds() {
        return this.cleanupDelaySeconds + ThreadLocalRandom.current().nextInt(this.cleanupDelaySeconds);
    }

    @Override
    public void close() {
        this.closed = true;
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        scheduledFuture.cancel(false);
        CLEANUP_EXECUTOR.execute(this::cleanupInactiveMeters);
    }

    private final class Meters {
        private final List<Tag> commonTags;
        @Nullable
        private Counter opened;
        @Nullable
        private Counter closed;
        @Nullable
        private Gauge active;
        private int numOpened;
        private int numClosed;

        Meters(List<Tag> commonTags) {
            this.commonTags = commonTags;
            if (!ConnectionPoolMetrics.this.garbageCollecting) {
                this.maybeRegisterMetrics();
            }
        }

        void maybeRegisterMetrics() {
            if (this.opened != null) {
                return;
            }
            this.opened = Counter.builder((String)ConnectionPoolMetrics.this.idPrefix.name("connections")).tags(this.commonTags).tag(ConnectionPoolMetrics.STATE, "opened").register(ConnectionPoolMetrics.this.meterRegistry);
            if (this.numOpened > 0) {
                this.opened.increment((double)this.numOpened);
            }
            this.closed = Counter.builder((String)ConnectionPoolMetrics.this.idPrefix.name("connections")).tags(this.commonTags).tag(ConnectionPoolMetrics.STATE, "closed").register(ConnectionPoolMetrics.this.meterRegistry);
            if (this.numClosed > 0) {
                this.closed.increment((double)this.numClosed);
            }
            this.active = Gauge.builder((String)ConnectionPoolMetrics.this.idPrefix.name("active.connections"), (Object)this, Meters::activeConnections).tags(this.commonTags).register(ConnectionPoolMetrics.this.meterRegistry);
        }

        void increment() {
            ++this.numOpened;
            if (this.opened != null) {
                this.opened.increment();
            }
        }

        void decrement() {
            ++this.numClosed;
            if (this.closed != null) {
                this.closed.increment();
            }
        }

        int activeConnections() {
            return this.numOpened - this.numClosed;
        }

        void remove(MeterRegistry registry) {
            if (this.opened != null) {
                assert (this.closed != null);
                assert (this.active != null);
                registry.remove((Meter)this.opened);
                registry.remove((Meter)this.closed);
                registry.remove((Meter)this.active);
            }
        }
    }
}

