/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.edec;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.interfaces.XDHPublicKey;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPublicKey;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import java.io.IOException;
import java.security.interfaces.XECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;

class BC11XDHPrivateKey
extends BCXDHPrivateKey
implements XECPrivateKey {
    BC11XDHPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC11XDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }

    public XDHPublicKey getPublicKey() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return new BC11XDHPublicKey(((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
        }
        return new BC11XDHPublicKey(((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
    }

    @Override
    public Optional<byte[]> getScalar() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return Optional.of(((X448PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
        }
        return Optional.of(((X25519PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
    }
}

