/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualServiceProcessor;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.EndpointMeta;
import org.apache.skywalking.oap.server.core.source.MQAccess;
import org.apache.skywalking.oap.server.core.source.MQEndpointAccess;
import org.apache.skywalking.oap.server.core.source.MQOperation;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class VirtualMQProcessor
implements VirtualServiceProcessor {
    private final NamingControl namingControl;
    private final List<Source> sourceList = new ArrayList<Source>();

    @Override
    public void prepareVSIfNecessary(SpanObject span, SegmentObject segmentObject) {
        String peer;
        MQOperation mqOperation;
        if (span.getSpanLayer() != SpanLayer.MQ) {
            return;
        }
        if (span.getSpanType() != SpanType.Exit && span.getSpanType() != SpanType.Entry) {
            return;
        }
        if (span.getSpanType() == SpanType.Entry) {
            mqOperation = MQOperation.Consume;
            peer = span.getRefsList().stream().findFirst().map(SegmentReference::getNetworkAddressUsedAtPeer).filter(StringUtil::isNotBlank).orElse(span.getPeer());
        } else {
            mqOperation = MQOperation.Produce;
            peer = span.getPeer();
        }
        if (StringUtil.isBlank((String)peer)) {
            return;
        }
        MQTags mqTags = this.collectTags(span.getTagsList());
        String serviceName = this.namingControl.formatServiceName(peer);
        long timeBucket = TimeBucket.getMinuteTimeBucket((long)span.getStartTime());
        this.sourceList.add((Source)this.toServiceMeta(serviceName, timeBucket));
        MQAccess access = new MQAccess();
        access.setTypeId(span.getComponentId());
        access.setTransmissionLatency(mqTags.transmissionLatency);
        access.setName(serviceName);
        access.setStatus(!span.getIsError());
        access.setTimeBucket(timeBucket);
        access.setOperation(mqOperation);
        this.sourceList.add((Source)access);
        String endpoint = this.buildEndpointName(mqTags.topic, mqTags.queue);
        if (!endpoint.isEmpty()) {
            String endpointName = this.namingControl.formatEndpointName(serviceName, endpoint);
            this.sourceList.add((Source)this.toEndpointMeta(serviceName, endpointName, timeBucket));
            MQEndpointAccess endpointAccess = new MQEndpointAccess();
            endpointAccess.setTypeId(span.getComponentId());
            endpointAccess.setTransmissionLatency(mqTags.transmissionLatency);
            endpointAccess.setStatus(!span.getIsError());
            endpointAccess.setTimeBucket(timeBucket);
            endpointAccess.setOperation(mqOperation);
            endpointAccess.setServiceName(serviceName);
            endpointAccess.setEndpoint(endpointName);
            this.sourceList.add((Source)endpointAccess);
        }
    }

    private String buildEndpointName(String topic, String queue) {
        return Stream.of(topic, queue).filter(StringUtil::isNotBlank).reduce((a, b) -> a + "/" + b).orElse("");
    }

    private MQTags collectTags(List<KeyStringValuePair> tagsList) {
        MQTags mqTags = new MQTags();
        for (KeyStringValuePair keyStringValuePair : tagsList) {
            if ("mq.topic".equals(keyStringValuePair.getKey())) {
                mqTags.topic = keyStringValuePair.getValue();
                continue;
            }
            if ("mq.queue".equals(keyStringValuePair.getKey())) {
                mqTags.queue = keyStringValuePair.getValue();
                continue;
            }
            if (!"transmission.latency".equals(keyStringValuePair.getKey())) continue;
            mqTags.transmissionLatency = StringUtil.isBlank((String)keyStringValuePair.getValue()) ? 0L : Long.parseLong(keyStringValuePair.getValue());
        }
        return mqTags;
    }

    private ServiceMeta toServiceMeta(String serviceName, Long timeBucket) {
        ServiceMeta service = new ServiceMeta();
        service.setName(serviceName);
        service.setLayer(Layer.VIRTUAL_MQ);
        service.setTimeBucket(timeBucket.longValue());
        return service;
    }

    private EndpointMeta toEndpointMeta(String serviceName, String endpoint, Long timeBucket) {
        EndpointMeta endpointMeta = new EndpointMeta();
        endpointMeta.setServiceName(serviceName);
        endpointMeta.setServiceNormal(false);
        endpointMeta.setEndpoint(endpoint);
        endpointMeta.setTimeBucket(timeBucket.longValue());
        return endpointMeta;
    }

    @Override
    public void emitTo(Consumer<Source> consumer) {
        this.sourceList.forEach(consumer);
    }

    @Generated
    public VirtualMQProcessor(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    private static class MQTags {
        private String topic;
        private String queue;
        private long transmissionLatency;

        private MQTags() {
        }
    }
}

