/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.analyzer.module.AnalyzerModule;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.meter.config.MeterConfig;
import org.apache.skywalking.oap.server.analyzer.provider.meter.config.MeterConfigs;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.IMeterProcessService;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.MeterProcessService;
import org.apache.skywalking.oap.server.analyzer.provider.trace.CacheReadLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.CacheWriteLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.TraceSamplingPolicyWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.UninstrumentedGatewaysConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.SegmentParserListenerManager;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.SegmentParserServiceImpl;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EndpointDepFromCrossThreadAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.NetworkAddressAliasMappingListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.RPCAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.SegmentAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.VirtualServiceAnalysisListener;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.core.oal.rt.CoreOALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class AnalyzerModuleProvider
extends ModuleProvider {
    private AnalyzerModuleConfig moduleConfig;
    private DBLatencyThresholdsAndWatcher dbLatencyThresholdsAndWatcher;
    private CacheReadLatencyThresholdsAndWatcher cacheReadLatencyThresholdsAndWatcher;
    private CacheWriteLatencyThresholdsAndWatcher cacheWriteLatencyThresholdsAndWatcher;
    private UninstrumentedGatewaysConfig uninstrumentedGatewaysConfig;
    private SegmentParserServiceImpl segmentParserService;
    private TraceSamplingPolicyWatcher traceSamplingPolicyWatcher;
    private List<MeterConfig> meterConfigs;
    private MeterProcessService processService;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return AnalyzerModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<AnalyzerModuleConfig>(){

            public Class type() {
                return AnalyzerModuleConfig.class;
            }

            public void onInitialized(AnalyzerModuleConfig initialized) {
                AnalyzerModuleProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.dbLatencyThresholdsAndWatcher = new DBLatencyThresholdsAndWatcher(this.moduleConfig.getSlowDBAccessThreshold(), this);
        this.uninstrumentedGatewaysConfig = new UninstrumentedGatewaysConfig(this);
        this.traceSamplingPolicyWatcher = new TraceSamplingPolicyWatcher(this.moduleConfig, this);
        this.cacheReadLatencyThresholdsAndWatcher = new CacheReadLatencyThresholdsAndWatcher(this.moduleConfig.getSlowCacheReadThreshold(), this);
        this.cacheWriteLatencyThresholdsAndWatcher = new CacheWriteLatencyThresholdsAndWatcher(this.moduleConfig.getSlowCacheWriteThreshold(), this);
        this.moduleConfig.setDbLatencyThresholdsAndWatcher(this.dbLatencyThresholdsAndWatcher);
        this.moduleConfig.setUninstrumentedGatewaysConfig(this.uninstrumentedGatewaysConfig);
        this.moduleConfig.setTraceSamplingPolicyWatcher(this.traceSamplingPolicyWatcher);
        this.moduleConfig.setCacheReadLatencyThresholdsAndWatcher(this.cacheReadLatencyThresholdsAndWatcher);
        this.moduleConfig.setCacheWriteLatencyThresholdsAndWatcher(this.cacheWriteLatencyThresholdsAndWatcher);
        this.segmentParserService = new SegmentParserServiceImpl(this.getManager(), this.moduleConfig);
        this.registerServiceImplementation(ISegmentParserService.class, this.segmentParserService);
        this.meterConfigs = MeterConfigs.loadConfig(this.moduleConfig.getConfigPath(), this.moduleConfig.meterAnalyzerActiveFileNames());
        this.processService = new MeterProcessService(this.getManager());
        this.registerServiceImplementation(IMeterProcessService.class, this.processService);
    }

    public void start() throws ModuleStartException {
        ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)CoreOALDefine.INSTANCE);
        DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)this.getManager().find("configuration").provider().getService(DynamicConfigurationService.class);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.dbLatencyThresholdsAndWatcher);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.uninstrumentedGatewaysConfig);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.traceSamplingPolicyWatcher);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.cacheReadLatencyThresholdsAndWatcher);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.cacheWriteLatencyThresholdsAndWatcher);
        this.segmentParserService.setListenerManager(this.listenerManager());
        this.processService.start(this.meterConfigs);
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "configuration"};
    }

    private SegmentParserListenerManager listenerManager() {
        SegmentParserListenerManager listenerManager = new SegmentParserListenerManager();
        if (this.moduleConfig.isTraceAnalysis()) {
            listenerManager.add(new RPCAnalysisListener.Factory(this.getManager()));
            listenerManager.add(new EndpointDepFromCrossThreadAnalysisListener.Factory(this.getManager()));
            listenerManager.add(new NetworkAddressAliasMappingListener.Factory(this.getManager()));
        }
        listenerManager.add(new SegmentAnalysisListener.Factory(this.getManager(), this.moduleConfig));
        listenerManager.add(new VirtualServiceAnalysisListener.Factory(this.getManager()));
        return listenerManager;
    }

    @Generated
    public AnalyzerModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    @Generated
    public DBLatencyThresholdsAndWatcher getDbLatencyThresholdsAndWatcher() {
        return this.dbLatencyThresholdsAndWatcher;
    }

    @Generated
    public UninstrumentedGatewaysConfig getUninstrumentedGatewaysConfig() {
        return this.uninstrumentedGatewaysConfig;
    }

    @Generated
    public SegmentParserServiceImpl getSegmentParserService() {
        return this.segmentParserService;
    }

    @Generated
    public TraceSamplingPolicyWatcher getTraceSamplingPolicyWatcher() {
        return this.traceSamplingPolicyWatcher;
    }

    @Generated
    public MeterProcessService getProcessService() {
        return this.processService;
    }
}

