/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalysisListenerManager;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListener;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAnalyzer.class);
    private final ModuleManager moduleManager;
    private final LogAnalyzerModuleConfig moduleConfig;
    private final ILogAnalysisListenerManager factoryManager;
    private final List<LogAnalysisListener> listeners = new ArrayList<LogAnalysisListener>();

    public void doAnalysis(LogData.Builder builder, Message extraLog) {
        Layer layer;
        if (StringUtil.isEmpty((String)builder.getService())) {
            log.debug("The log is ignored because the Service name is empty");
            return;
        }
        if ("".equals(builder.getLayer())) {
            layer = Layer.GENERAL;
        } else {
            try {
                layer = Layer.nameOf((String)builder.getLayer());
            }
            catch (UnexpectedException e) {
                log.warn("The Layer {} is not found, abandon the log.", (Object)builder.getLayer());
                return;
            }
        }
        this.createAnalysisListeners(layer);
        if (builder.getTimestamp() == 0L) {
            builder.setTimestamp(System.currentTimeMillis());
        }
        this.notifyAnalysisListener(builder, extraLog);
        this.notifyAnalysisListenerToBuild();
    }

    private void notifyAnalysisListener(LogData.Builder builder, Message extraLog) {
        this.listeners.forEach(listener -> listener.parse(builder, extraLog));
    }

    private void notifyAnalysisListenerToBuild() {
        this.listeners.forEach(LogAnalysisListener::build);
    }

    private void createAnalysisListeners(Layer layer) {
        this.factoryManager.getLogAnalysisListenerFactories().stream().map(factory -> factory.create(layer)).filter(Objects::nonNull).forEach(this.listeners::add);
    }

    @Generated
    public LogAnalyzer(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig, ILogAnalysisListenerManager factoryManager) {
        this.moduleManager = moduleManager;
        this.moduleConfig = moduleConfig;
        this.factoryManager = factoryManager;
    }
}

