/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.PublicApi;
import graphql.Scalars;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.ScalarTypeDefinition;
import graphql.schema.GraphQLScalarType;
import java.util.List;
import java.util.Map;

@PublicApi
public class ScalarInfo {
    public static final List<GraphQLScalarType> GRAPHQL_SPECIFICATION_SCALARS = ImmutableList.of(Scalars.GraphQLInt, Scalars.GraphQLFloat, Scalars.GraphQLString, Scalars.GraphQLBoolean, Scalars.GraphQLID);
    public static final Map<String, ScalarTypeDefinition> GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS = ImmutableMap.of("Int", ScalarTypeDefinition.newScalarTypeDefinition().name("Int").build(), "Float", ScalarTypeDefinition.newScalarTypeDefinition().name("Float").build(), "String", ScalarTypeDefinition.newScalarTypeDefinition().name("String").build(), "Boolean", ScalarTypeDefinition.newScalarTypeDefinition().name("Boolean").build(), "ID", ScalarTypeDefinition.newScalarTypeDefinition().name("ID").build());

    public static boolean isGraphqlSpecifiedScalar(String scalarTypeName) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarTypeName);
    }

    public static boolean isGraphqlSpecifiedScalar(GraphQLScalarType scalarType) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarType.getName());
    }

    private static boolean inList(List<GraphQLScalarType> scalarList, String scalarTypeName) {
        return scalarList.stream().anyMatch(sc -> sc.getName().equals(scalarTypeName));
    }
}

