/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class GraphqlFloatCoercing
implements Coercing<Double, Double> {
    private Double convertImpl(Object input) {
        Double doubleInput;
        if (input instanceof Double) {
            doubleInput = (Double)input;
        } else if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            doubleInput = value.doubleValue();
        } else {
            return null;
        }
        if (Double.isNaN(doubleInput) || Double.isInfinite(doubleInput)) {
            return null;
        }
        return doubleInput;
    }

    @NotNull
    private Double serialiseImpl(Object input, @NotNull Locale locale) {
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)));
        }
        return result;
    }

    @NotNull
    private Double parseValueImpl(@NotNull Object input, @NotNull Locale locale) {
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private static double parseLiteralImpl(@NotNull Object input, @NotNull Locale locale) {
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue().doubleValue();
        }
        if (input instanceof FloatValue) {
            return ((FloatValue)input).getValue().doubleValue();
        }
        throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Float.unexpectedAstType", CoercingUtil.typeName(input)));
    }

    @NotNull
    private FloatValue valueToLiteralImpl(Object input, @NotNull Locale locale) {
        Double result = Assert.assertNotNull(this.convertImpl(input), () -> CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)));
        return FloatValue.newFloatValue(BigDecimal.valueOf(result)).build();
    }

    @Override
    @Deprecated
    public Double serialize(@NotNull Object dataFetcherResult) {
        return this.serialiseImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    @Nullable
    public Double serialize(@NotNull Object dataFetcherResult, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingSerializeException {
        return this.serialiseImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    @NotNull
    public Double parseValue(@NotNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Double parseValue(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public Double parseLiteral(@NotNull Object input) {
        return GraphqlFloatCoercing.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @Nullable
    public Double parseLiteral(@NotNull Value<?> input, @NotNull CoercedVariables variables, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseLiteralException {
        return GraphqlFloatCoercing.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NotNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

