/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.QueryComplexityCalculator;
import graphql.analysis.QueryComplexityInfo;
import graphql.execution.AbortExecutionException;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.validation.ValidationError;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class MaxQueryComplexityInstrumentation
extends SimplePerformantInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MaxQueryComplexityInstrumentation.class);
    private final int maxComplexity;
    private final FieldComplexityCalculator fieldComplexityCalculator;
    private final Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction;

    public MaxQueryComplexityInstrumentation(int maxComplexity) {
        this(maxComplexity, (QueryComplexityInfo queryComplexityInfo) -> true);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction) {
        this(maxComplexity, (env, childComplexity) -> 1 + childComplexity, maxQueryComplexityExceededFunction);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator) {
        this(maxComplexity, fieldComplexityCalculator, queryComplexityInfo -> true);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator, Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction) {
        this.maxComplexity = maxComplexity;
        this.fieldComplexityCalculator = Assert.assertNotNull(fieldComplexityCalculator, () -> "calculator can't be null");
        this.maxQueryComplexityExceededFunction = maxQueryComplexityExceededFunction;
    }

    @Override
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new State();
    }

    @Override
    @Nullable
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState rawState) {
        State state = (State)InstrumentationState.ofState(rawState);
        state.instrumentationValidationParameters.set(parameters);
        return SimpleInstrumentationContext.noOp();
    }

    @Override
    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters instrumentationExecuteOperationParameters, InstrumentationState rawState) {
        QueryComplexityInfo queryComplexityInfo;
        boolean throwAbortException;
        State state = (State)InstrumentationState.ofState(rawState);
        QueryComplexityCalculator queryComplexityCalculator = this.newQueryComplexityCalculator(instrumentationExecuteOperationParameters.getExecutionContext());
        int totalComplexity = queryComplexityCalculator.calculate();
        if (log.isDebugEnabled()) {
            log.debug("Query complexity: {}", (Object)totalComplexity);
        }
        if (totalComplexity > this.maxComplexity && (throwAbortException = this.maxQueryComplexityExceededFunction.apply(queryComplexityInfo = QueryComplexityInfo.newQueryComplexityInfo().complexity(totalComplexity).instrumentationValidationParameters(state.instrumentationValidationParameters.get()).instrumentationExecuteOperationParameters(instrumentationExecuteOperationParameters).build()).booleanValue())) {
            throw this.mkAbortException(totalComplexity, this.maxComplexity);
        }
        return SimpleInstrumentationContext.noOp();
    }

    private QueryComplexityCalculator newQueryComplexityCalculator(ExecutionContext executionContext) {
        return QueryComplexityCalculator.newCalculator().fieldComplexityCalculator(this.fieldComplexityCalculator).schema(executionContext.getGraphQLSchema()).document(executionContext.getDocument()).operationName(executionContext.getExecutionInput().getOperationName()).variables(executionContext.getCoercedVariables()).build();
    }

    protected AbortExecutionException mkAbortException(int totalComplexity, int maxComplexity) {
        return new AbortExecutionException("maximum query complexity exceeded " + totalComplexity + " > " + maxComplexity);
    }

    private static class State
    implements InstrumentationState {
        AtomicReference<InstrumentationValidationParameters> instrumentationValidationParameters = new AtomicReference();

        private State() {
        }
    }
}

