/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.HashMap;
import java.util.Properties;
import lombok.Generated;

public class ApplicationConfiguration {
    private HashMap<String, ModuleConfiguration> modules = new HashMap();

    public String[] moduleList() {
        return this.modules.keySet().toArray(new String[0]);
    }

    public ModuleConfiguration addModule(String moduleName) {
        ModuleConfiguration newModule = new ModuleConfiguration(moduleName);
        this.modules.put(moduleName, newModule);
        return newModule;
    }

    public boolean has(String moduleName) {
        return this.modules.containsKey(moduleName);
    }

    public ModuleConfiguration getModuleConfiguration(String name) {
        return this.modules.get(name);
    }

    public static class ModuleConfiguration {
        private final String moduleName;
        private HashMap<String, ProviderConfiguration> providers = new HashMap();

        private ModuleConfiguration(String moduleName) {
            this.moduleName = moduleName;
        }

        public Properties getProviderConfiguration(String name) {
            return this.providers.get(name).getProperties();
        }

        public boolean has(String name) {
            return this.providers.containsKey(name);
        }

        public ModuleConfiguration addProviderConfiguration(String name, Properties properties) {
            ProviderConfiguration newProvider = new ProviderConfiguration(properties);
            this.providers.put(name, newProvider);
            return this;
        }

        @Generated
        public String getModuleName() {
            return this.moduleName;
        }

        @Generated
        public HashMap<String, ProviderConfiguration> getProviders() {
            return this.providers;
        }
    }

    public static class ProviderConfiguration {
        private Properties properties;

        ProviderConfiguration(Properties properties) {
            this.properties = properties;
        }

        @Generated
        public Properties getProperties() {
            return this.properties;
        }
    }
}

