/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.telegraf.provider;

import com.google.common.base.Splitter;
import com.linecorp.armeria.common.HttpMethod;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.telegraf.module.TelegrafReceiverModule;
import org.apache.skywalking.oap.server.receiver.telegraf.provider.TelegrafModuleConfig;
import org.apache.skywalking.oap.server.receiver.telegraf.provider.handler.TelegrafServiceHandler;

public class TelegrafReceiverProvider
extends ModuleProvider {
    private List<Rule> configs;
    private TelegrafModuleConfig moduleConfig;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return TelegrafReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<TelegrafModuleConfig>(){

            public Class type() {
                return TelegrafModuleConfig.class;
            }

            public void onInitialized(TelegrafModuleConfig initialized) {
                TelegrafReceiverProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        try {
            this.configs = Rules.loadRules((String)"telegraf-rules", StringUtil.isEmpty((String)this.moduleConfig.getActiveFiles()) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)this.moduleConfig.getActiveFiles()));
        }
        catch (IOException e) {
            throw new ModuleStartException("Failed to load MAL rules", (Throwable)e);
        }
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (CollectionUtils.isNotEmpty(this.configs)) {
            HTTPHandlerRegister httpHandlerRegister = (HTTPHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(HTTPHandlerRegister.class);
            MeterSystem meterSystem = (MeterSystem)this.getManager().find("core").provider().getService(MeterSystem.class);
            httpHandlerRegister.addHandler((Object)new TelegrafServiceHandler(this.getManager(), meterSystem, this.configs), Collections.singletonList(HttpMethod.POST));
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"core", "receiver-sharing-server"};
    }
}

