/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.exception.ResponseException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDeleteEsDAO
extends EsDAO
implements IHistoryDeleteDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryDeleteEsDAO.class);
    private final Map<String, Long> indexLatestSuccess = new HashMap<String, Long>();

    public HistoryDeleteEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public void deleteHistory(Model model, String timeBucketColumnName, int ttl) {
        ElasticSearchClient client = (ElasticSearchClient)this.getClient();
        if (!model.isRecord() && !DownSampling.Minute.equals((Object)model.getDownsampling())) {
            return;
        }
        long deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMdd"));
        String tableName = IndexController.INSTANCE.getTableName(model);
        Long latestSuccessDeadline = this.indexLatestSuccess.get(model.getName());
        if (latestSuccessDeadline != null && deadline <= latestSuccessDeadline) {
            if (log.isDebugEnabled()) {
                log.debug("Index = {} already deleted, skip, deadline = {}, ttl = {}", new Object[]{tableName, deadline, ttl});
            }
            return;
        }
        String latestIndex = TimeSeriesUtils.latestWriteIndexName(model);
        if (!client.isExistsIndex(latestIndex)) {
            try {
                client.createIndex(latestIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Latest index = {} is not exist, create.", (Object)latestIndex);
                }
            }
            catch (ResponseException e) {
                if (e.getStatusCode() == 400 && client.isExistsIndex(latestIndex)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to create index {}, index is already created.", (Object)latestIndex);
                    }
                }
                throw e;
            }
        }
        Collection indices = client.retrievalIndexByAliases(tableName);
        if (log.isDebugEnabled()) {
            log.debug("Deadline = {}, indices = {}, ttl = {}", new Object[]{deadline, indices, ttl});
        }
        ArrayList<String> prepareDeleteIndexes = new ArrayList<String>();
        for (String index : indices) {
            long timeSeries = TimeSeriesUtils.isolateTimeFromIndexName(index);
            if (deadline < timeSeries) continue;
            prepareDeleteIndexes.add(index);
        }
        if (log.isDebugEnabled()) {
            log.debug("Indices to be deleted: {}", prepareDeleteIndexes);
        }
        for (String prepareDeleteIndex : prepareDeleteIndexes) {
            client.deleteByIndexName(prepareDeleteIndex);
        }
        this.indexLatestSuccess.put(tableName, deadline);
    }
}

