/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Token;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Token", generator="Immutables")
@Immutable
public final class ImmutableToken
extends Token {
    @Nullable
    private final String id;
    @Nullable
    private final String secretId;
    @Nullable
    private final String description;
    private final ImmutableList<Token.PolicyLink> policies;
    private final ImmutableList<Token.RoleLink> roles;
    private final ImmutableList<Token.ServiceIdentity> serviceIdentities;
    private final ImmutableList<Token.NodeIdentity> nodeIdentities;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String expirationTime;
    @Nullable
    private final String expirationTTL;
    @Nullable
    private final String namespace;

    private ImmutableToken(@Nullable String id, @Nullable String secretId, @Nullable String description, ImmutableList<Token.PolicyLink> policies, ImmutableList<Token.RoleLink> roles, ImmutableList<Token.ServiceIdentity> serviceIdentities, ImmutableList<Token.NodeIdentity> nodeIdentities, @Nullable Boolean local, @Nullable String expirationTime, @Nullable String expirationTTL, @Nullable String namespace) {
        this.id = id;
        this.secretId = secretId;
        this.description = description;
        this.policies = policies;
        this.roles = roles;
        this.serviceIdentities = serviceIdentities;
        this.nodeIdentities = nodeIdentities;
        this.local = local;
        this.expirationTime = expirationTime;
        this.expirationTTL = expirationTTL;
        this.namespace = namespace;
    }

    @Override
    @JsonProperty(value="AccessorID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="SecretID")
    public Optional<String> secretId() {
        return Optional.ofNullable(this.secretId);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Token.PolicyLink.class)
    public ImmutableList<Token.PolicyLink> policies() {
        return this.policies;
    }

    @JsonProperty(value="Roles")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Token.RoleLink.class)
    public ImmutableList<Token.RoleLink> roles() {
        return this.roles;
    }

    @JsonProperty(value="ServiceIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Token.ServiceIdentity.class)
    public ImmutableList<Token.ServiceIdentity> serviceIdentities() {
        return this.serviceIdentities;
    }

    @JsonProperty(value="NodeIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Token.NodeIdentity.class)
    public ImmutableList<Token.NodeIdentity> nodeIdentities() {
        return this.nodeIdentities;
    }

    @Override
    @JsonProperty(value="Local")
    public Optional<Boolean> local() {
        return Optional.ofNullable(this.local);
    }

    @Override
    @JsonProperty(value="ExpirationTime")
    public Optional<String> expirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    @Override
    @JsonProperty(value="ExpirationTTL")
    public Optional<String> expirationTTL() {
        return Optional.ofNullable(this.expirationTTL);
    }

    @Override
    @JsonProperty(value="Namespace")
    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final ImmutableToken withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableToken(newValue, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableToken(value, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withSecretId(String value) {
        String newValue = Objects.requireNonNull(value, "secretId");
        if (Objects.equals(this.secretId, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, newValue, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withSecretId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.secretId, value)) {
            return this;
        }
        return new ImmutableToken(this.id, value, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, newValue, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, value, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withPolicies(Token.PolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableToken(this.id, this.secretId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withPolicies(Iterable<? extends Token.PolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableToken(this.id, this.secretId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withRoles(Token.RoleLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, (ImmutableList<Token.RoleLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withRoles(Iterable<? extends Token.RoleLink> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, (ImmutableList<Token.RoleLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withServiceIdentities(Token.ServiceIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, (ImmutableList<Token.ServiceIdentity>)newValue, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withServiceIdentities(Iterable<? extends Token.ServiceIdentity> elements) {
        if (this.serviceIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, (ImmutableList<Token.ServiceIdentity>)newValue, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withNodeIdentities(Token.NodeIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, (ImmutableList<Token.NodeIdentity>)newValue, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withNodeIdentities(Iterable<? extends Token.NodeIdentity> elements) {
        if (this.nodeIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, (ImmutableList<Token.NodeIdentity>)newValue, this.local, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withLocal(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.local, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, newValue, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withLocal(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.local, value)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, value, this.expirationTime, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withExpirationTime(String value) {
        String newValue = Objects.requireNonNull(value, "expirationTime");
        if (Objects.equals(this.expirationTime, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, newValue, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withExpirationTime(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.expirationTime, value)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, value, this.expirationTTL, this.namespace);
    }

    public final ImmutableToken withExpirationTTL(String value) {
        String newValue = Objects.requireNonNull(value, "expirationTTL");
        if (Objects.equals(this.expirationTTL, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, newValue, this.namespace);
    }

    public final ImmutableToken withExpirationTTL(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.expirationTTL, value)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, value, this.namespace);
    }

    public final ImmutableToken withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, newValue);
    }

    public final ImmutableToken withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableToken(this.id, this.secretId, this.description, this.policies, this.roles, this.serviceIdentities, this.nodeIdentities, this.local, this.expirationTime, this.expirationTTL, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToken && this.equalTo((ImmutableToken)another);
    }

    private boolean equalTo(ImmutableToken another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.secretId, another.secretId) && Objects.equals(this.description, another.description) && this.policies.equals(another.policies) && this.roles.equals(another.roles) && this.serviceIdentities.equals(another.serviceIdentities) && this.nodeIdentities.equals(another.nodeIdentities) && Objects.equals(this.local, another.local) && Objects.equals(this.expirationTime, another.expirationTime) && Objects.equals(this.expirationTTL, another.expirationTTL) && Objects.equals(this.namespace, another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.secretId);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.serviceIdentities.hashCode();
        h += (h << 5) + this.nodeIdentities.hashCode();
        h += (h << 5) + Objects.hashCode(this.local);
        h += (h << 5) + Objects.hashCode(this.expirationTime);
        h += (h << 5) + Objects.hashCode(this.expirationTTL);
        h += (h << 5) + Objects.hashCode(this.namespace);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Token").omitNullValues().add("id", (Object)this.id).add("secretId", (Object)this.secretId).add("description", (Object)this.description).add("policies", this.policies).add("roles", this.roles).add("serviceIdentities", this.serviceIdentities).add("nodeIdentities", this.nodeIdentities).add("local", (Object)this.local).add("expirationTime", (Object)this.expirationTime).add("expirationTTL", (Object)this.expirationTTL).add("namespace", (Object)this.namespace).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableToken fromJson(Json json) {
        Builder builder = ImmutableToken.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.secretId != null) {
            builder.secretId(json.secretId);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.serviceIdentities != null) {
            builder.addAllServiceIdentities(json.serviceIdentities);
        }
        if (json.nodeIdentities != null) {
            builder.addAllNodeIdentities(json.nodeIdentities);
        }
        if (json.local != null) {
            builder.local(json.local);
        }
        if (json.expirationTime != null) {
            builder.expirationTime(json.expirationTime);
        }
        if (json.expirationTTL != null) {
            builder.expirationTTL(json.expirationTTL);
        }
        if (json.namespace != null) {
            builder.namespace(json.namespace);
        }
        return builder.build();
    }

    public static ImmutableToken copyOf(Token instance) {
        if (instance instanceof ImmutableToken) {
            return (ImmutableToken)instance;
        }
        return ImmutableToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String secretId;
        @Nullable
        private String description;
        private ImmutableList.Builder<Token.PolicyLink> policies = ImmutableList.builder();
        private ImmutableList.Builder<Token.RoleLink> roles = ImmutableList.builder();
        private ImmutableList.Builder<Token.ServiceIdentity> serviceIdentities = ImmutableList.builder();
        private ImmutableList.Builder<Token.NodeIdentity> nodeIdentities = ImmutableList.builder();
        @Nullable
        private Boolean local;
        @Nullable
        private String expirationTime;
        @Nullable
        private String expirationTTL;
        @Nullable
        private String namespace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token instance) {
            Optional<String> namespaceOptional;
            Optional<String> expirationTTLOptional;
            Optional<String> expirationTimeOptional;
            Optional<String> descriptionOptional;
            Optional<String> secretIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((secretIdOptional = instance.secretId()).isPresent()) {
                this.secretId(secretIdOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllPolicies(instance.policies());
            this.addAllRoles(instance.roles());
            this.addAllServiceIdentities(instance.serviceIdentities());
            this.addAllNodeIdentities(instance.nodeIdentities());
            Optional<Boolean> localOptional = instance.local();
            if (localOptional.isPresent()) {
                this.local(localOptional);
            }
            if ((expirationTimeOptional = instance.expirationTime()).isPresent()) {
                this.expirationTime(expirationTimeOptional);
            }
            if ((expirationTTLOptional = instance.expirationTTL()).isPresent()) {
                this.expirationTTL(expirationTTLOptional);
            }
            if ((namespaceOptional = instance.namespace()).isPresent()) {
                this.namespace(namespaceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="AccessorID")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secretId(String secretId) {
            this.secretId = Objects.requireNonNull(secretId, "secretId");
            return this;
        }

        @JsonProperty(value="SecretID")
        @CanIgnoreReturnValue
        public final Builder secretId(Optional<String> secretId) {
            this.secretId = secretId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Token.PolicyLink element) {
            this.policies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Token.PolicyLink ... elements) {
            this.policies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Policies")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.PolicyLink.class)
        @CanIgnoreReturnValue
        public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
            this.policies = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
            this.policies.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(Token.RoleLink element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(Token.RoleLink ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Roles")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.RoleLink.class)
        @CanIgnoreReturnValue
        public final Builder roles(Iterable<? extends Token.RoleLink> elements) {
            this.roles = ImmutableList.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<? extends Token.RoleLink> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Token.ServiceIdentity element) {
            this.serviceIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Token.ServiceIdentity ... elements) {
            this.serviceIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.ServiceIdentity.class)
        @CanIgnoreReturnValue
        public final Builder serviceIdentities(Iterable<? extends Token.ServiceIdentity> elements) {
            this.serviceIdentities = ImmutableList.builder();
            return this.addAllServiceIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceIdentities(Iterable<? extends Token.ServiceIdentity> elements) {
            this.serviceIdentities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Token.NodeIdentity element) {
            this.nodeIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Token.NodeIdentity ... elements) {
            this.nodeIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="NodeIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.NodeIdentity.class)
        @CanIgnoreReturnValue
        public final Builder nodeIdentities(Iterable<? extends Token.NodeIdentity> elements) {
            this.nodeIdentities = ImmutableList.builder();
            return this.addAllNodeIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeIdentities(Iterable<? extends Token.NodeIdentity> elements) {
            this.nodeIdentities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder local(boolean local) {
            this.local = local;
            return this;
        }

        @JsonProperty(value="Local")
        @CanIgnoreReturnValue
        public final Builder local(Optional<Boolean> local) {
            this.local = local.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
            return this;
        }

        @JsonProperty(value="ExpirationTime")
        @CanIgnoreReturnValue
        public final Builder expirationTime(Optional<String> expirationTime) {
            this.expirationTime = expirationTime.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expirationTTL(String expirationTTL) {
            this.expirationTTL = Objects.requireNonNull(expirationTTL, "expirationTTL");
            return this;
        }

        @JsonProperty(value="ExpirationTTL")
        @CanIgnoreReturnValue
        public final Builder expirationTTL(Optional<String> expirationTTL) {
            this.expirationTTL = expirationTTL.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @JsonProperty(value="Namespace")
        @CanIgnoreReturnValue
        public final Builder namespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        public ImmutableToken build() {
            return new ImmutableToken(this.id, this.secretId, this.description, this.policies.build(), this.roles.build(), this.serviceIdentities.build(), this.nodeIdentities.build(), this.local, this.expirationTime, this.expirationTTL, this.namespace);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Token", generator="Immutables")
    static final class Json
    extends Token {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> secretId = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<Token.PolicyLink> policies = ImmutableList.of();
        @Nullable
        List<Token.RoleLink> roles = ImmutableList.of();
        @Nullable
        List<Token.ServiceIdentity> serviceIdentities = ImmutableList.of();
        @Nullable
        List<Token.NodeIdentity> nodeIdentities = ImmutableList.of();
        @Nullable
        Optional<Boolean> local = Optional.empty();
        @Nullable
        Optional<String> expirationTime = Optional.empty();
        @Nullable
        Optional<String> expirationTTL = Optional.empty();
        @Nullable
        Optional<String> namespace = Optional.empty();

        Json() {
        }

        @JsonProperty(value="AccessorID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="SecretID")
        public void setSecretId(Optional<String> secretId) {
            this.secretId = secretId;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Policies")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.PolicyLink.class)
        public void setPolicies(List<Token.PolicyLink> policies) {
            this.policies = policies;
        }

        @JsonProperty(value="Roles")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.RoleLink.class)
        public void setRoles(List<Token.RoleLink> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="ServiceIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.ServiceIdentity.class)
        public void setServiceIdentities(List<Token.ServiceIdentity> serviceIdentities) {
            this.serviceIdentities = serviceIdentities;
        }

        @JsonProperty(value="NodeIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.NodeIdentity.class)
        public void setNodeIdentities(List<Token.NodeIdentity> nodeIdentities) {
            this.nodeIdentities = nodeIdentities;
        }

        @JsonProperty(value="Local")
        public void setLocal(Optional<Boolean> local) {
            this.local = local;
        }

        @JsonProperty(value="ExpirationTime")
        public void setExpirationTime(Optional<String> expirationTime) {
            this.expirationTime = expirationTime;
        }

        @JsonProperty(value="ExpirationTTL")
        public void setExpirationTTL(Optional<String> expirationTTL) {
            this.expirationTTL = expirationTTL;
        }

        @JsonProperty(value="Namespace")
        public void setNamespace(Optional<String> namespace) {
            this.namespace = namespace;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> secretId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.PolicyLink> policies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.RoleLink> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.ServiceIdentity> serviceIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.NodeIdentity> nodeIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> local() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> expirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> expirationTTL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> namespace() {
            throw new UnsupportedOperationException();
        }
    }
}

