/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.text.DecimalFormat;
import java.util.concurrent.CompletableFuture;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.ParseErrorListener;
import org.apache.skywalking.mqe.rt.grammar.MQELexer;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.query.graphql.mqe.rt.MQEVisitor;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTrace;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetricsExpressionQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private final DecimalFormat valueFormat = new DecimalFormat();

    public MetricsExpressionQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.valueFormat.setGroupingUsed(false);
    }

    public CompletableFuture<ExpressionResult> execExpression(String expression, Entity entity, Duration duration, boolean debug, boolean dumpStorageRsp) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("Expression: " + expression + ", Entity: " + entity + ", Duration: " + duration, debug, dumpStorageRsp);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("MQE query");
            try {
                MQEParser.ExpressionContext tree;
                MQEVisitor visitor = new MQEVisitor(this.moduleManager, entity, duration);
                DebuggingTrace execTrace = traceContext.getExecTrace();
                DebuggingSpan syntaxSpan = traceContext.createSpan("MQE syntax analysis");
                try {
                    MQELexer lexer = new MQELexer((CharStream)CharStreams.fromString((String)expression));
                    lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
                    MQEParser parser = new MQEParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                    parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
                    try {
                        tree = parser.expression();
                    }
                    catch (ParseCancellationException e) {
                        ExpressionResult errorResult = new ExpressionResult();
                        errorResult.setType(ExpressionResultType.UNKNOWN);
                        errorResult.setError(e.getMessage());
                        ExpressionResult expressionResult = errorResult;
                        traceContext.stopSpan(syntaxSpan);
                        traceContext.stopSpan(span);
                        traceContext.stopTrace();
                        DebuggingTraceContext.TRACE_CONTEXT.remove();
                        return expressionResult;
                    }
                }
                finally {
                    traceContext.stopSpan(syntaxSpan);
                }
                ExpressionResult parseResult = (ExpressionResult)visitor.visit((ParseTree)tree);
                parseResult.getResults().forEach(mqeValues -> mqeValues.getValues().forEach(mqeValue -> {
                    if (!mqeValue.isEmptyValue()) {
                        mqeValue.setValue(this.valueFormat.format(mqeValue.getDoubleValue()));
                    }
                }));
                if (debug) {
                    parseResult.setDebuggingTrace(execTrace);
                }
                ExpressionResult expressionResult = parseResult;
                return expressionResult;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }
}

