/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.setup;

import java.util.Collection;
import org.apache.shardingsphere.elasticjob.kernel.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.kernel.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.kernel.internal.listener.ListenerManager;
import org.apache.shardingsphere.elasticjob.kernel.internal.reconcile.ReconcileService;
import org.apache.shardingsphere.elasticjob.kernel.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;

public final class SetUpFacade {
    private final LeaderService leaderService;
    private final ServerService serverService;
    private final InstanceService instanceService;
    private final ReconcileService reconcileService;
    private final ListenerManager listenerManager;
    private final String jobName;
    private final CoordinatorRegistryCenter regCenter;

    public SetUpFacade(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners) {
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.reconcileService = new ReconcileService(regCenter, jobName);
        this.listenerManager = new ListenerManager(regCenter, jobName, elasticJobListeners);
        this.jobName = jobName;
        this.regCenter = regCenter;
    }

    public void registerStartUpInfo(boolean enabled) {
        this.listenerManager.startAllListeners();
        this.leaderService.electLeader();
        this.serverService.persistOnline(enabled);
        this.instanceService.persistOnline();
        if (!this.reconcileService.isRunning()) {
            this.reconcileService.startAsync();
        }
        this.serverService.removeOfflineServers();
    }

    public void tearDown() {
        this.regCenter.removeConnStateListener("/" + this.jobName);
        this.regCenter.removeDataListeners("/" + this.jobName);
        if (this.reconcileService.isRunning()) {
            this.reconcileService.stopAsync();
        }
    }
}

