/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.codec.MySQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.netty.MySQLSequenceIdInboundHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.MySQLAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLStatementIdGenerator;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelInboundHandler;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class MySQLFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final AuthenticationEngine authenticationEngine = new MySQLAuthenticationEngine();
    private final MySQLCommandExecuteEngine commandExecuteEngine = new MySQLCommandExecuteEngine();
    private final DatabasePacketCodecEngine codecEngine = new MySQLPacketCodecEngine();

    public void initChannel(Channel channel) {
        channel.pipeline().addBefore(FrontendChannelInboundHandler.class.getSimpleName(), MySQLSequenceIdInboundHandler.class.getSimpleName(), (ChannelHandler)new MySQLSequenceIdInboundHandler(channel));
    }

    public void release(ConnectionSession connectionSession) {
        MySQLStatementIdGenerator.getInstance().unregisterConnection(connectionSession.getConnectionId());
    }

    public void handleException(ConnectionSession connectionSession, Exception exception) {
    }

    public String getDatabaseType() {
        return "MySQL";
    }

    @Generated
    public AuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public MySQLCommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public DatabasePacketCodecEngine getCodecEngine() {
        return this.codecEngine;
    }
}

