/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.version;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaDataVersionPersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaDataVersionPersistService.class);
    private final PersistRepository repository;

    public void switchActiveVersion(Collection<MetaDataVersion> metaDataVersions) {
        for (MetaDataVersion each : metaDataVersions) {
            if (each.getNextActiveVersion().equals(each.getCurrentActiveVersion())) continue;
            this.repository.persist(each.getActiveVersionNodePath(), each.getNextActiveVersion());
            this.getVersions(each.getVersionsPath()).stream().filter(version -> Integer.parseInt(version) < Integer.parseInt(each.getNextActiveVersion())).forEach(version -> this.repository.delete(each.getVersionsNodePath(version)));
        }
    }

    public String getVersionPathByActiveVersion(String path, String activeVersion) {
        return this.repository.query(DatabaseMetaDataNodePath.getVersionPath((String)path, (String)activeVersion));
    }

    public List<String> getVersions(String path) {
        List result = this.repository.getChildrenKeys(path);
        if (result.size() > 2) {
            log.warn("There are multiple versions of \uff1a{}, please check the configuration.", (Object)path);
            result.sort((v1, v2) -> Integer.compare(Integer.parseInt(v2), Integer.parseInt(v1)));
        }
        return result;
    }

    @Generated
    public MetaDataVersionPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

