/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.ShowShardingTableRulesUsedAlgorithmStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRulesUsedAlgorithmExecutor
implements DistSQLQueryExecutor<ShowShardingTableRulesUsedAlgorithmStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowShardingTableRulesUsedAlgorithmStatement sqlStatement) {
        return Arrays.asList("type", "name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShardingTableRulesUsedAlgorithmStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.getShardingAlgorithmName().isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        ShardingRuleConfiguration ruleConfig = this.rule.getConfiguration();
        String algorithmName = (String)sqlStatement.getShardingAlgorithmName().get();
        boolean matchDefaultDatabaseShardingStrategy = null != ruleConfig.getDefaultDatabaseShardingStrategy() && algorithmName.equals(ruleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        boolean matchDefaultTableShardingStrategy = null != ruleConfig.getDefaultTableShardingStrategy() && algorithmName.equals(ruleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        ruleConfig.getTables().forEach(each -> {
            if (this.isMatchDatabaseShardingStrategy((ShardingTableRuleConfiguration)each, algorithmName, matchDefaultDatabaseShardingStrategy) || this.isMatchTableShardingStrategy((ShardingTableRuleConfiguration)each, algorithmName, matchDefaultTableShardingStrategy)) {
                result.add(new LocalDataQueryResultRow(new Object[]{"table", each.getLogicTable()}));
            }
        });
        ruleConfig.getAutoTables().forEach(each -> {
            if (null != each.getShardingStrategy() && algorithmName.equals(each.getShardingStrategy().getShardingAlgorithmName())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"auto_table", each.getLogicTable()}));
            }
        });
        return result;
    }

    private boolean isMatchDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName, boolean matchDefaultDatabaseShardingStrategy) {
        return this.isMatchDatabaseShardingStrategy(tableRuleConfig, algorithmName) || this.isMatchDefaultDatabaseShardingStrategy(tableRuleConfig, matchDefaultDatabaseShardingStrategy);
    }

    private boolean isMatchDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName) {
        return null != tableRuleConfig.getDatabaseShardingStrategy() && algorithmName.equals(tableRuleConfig.getDatabaseShardingStrategy().getShardingAlgorithmName());
    }

    private boolean isMatchDefaultDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, boolean matchDefaultDatabaseShardingStrategy) {
        return null == tableRuleConfig.getDatabaseShardingStrategy() && matchDefaultDatabaseShardingStrategy;
    }

    private boolean isMatchTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName, boolean matchDefaultTableShardingStrategy) {
        return this.isMatchTableShardingStrategy(tableRuleConfig, algorithmName) || this.isMatchDefaultTableShardingStrategy(tableRuleConfig, matchDefaultTableShardingStrategy);
    }

    private boolean isMatchTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName) {
        return null != tableRuleConfig.getTableShardingStrategy() && algorithmName.equals(tableRuleConfig.getTableShardingStrategy().getShardingAlgorithmName());
    }

    private boolean isMatchDefaultTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, boolean matchDefaultTableShardingStrategy) {
        return null == tableRuleConfig.getTableShardingStrategy() && matchDefaultTableShardingStrategy;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowShardingTableRulesUsedAlgorithmStatement> getType() {
        return ShowShardingTableRulesUsedAlgorithmStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

