/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRuleExecutor
implements DistSQLQueryExecutor<ShowShardingTableRulesStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowShardingTableRulesStatement sqlStatement) {
        return Arrays.asList("table", "actual_data_nodes", "actual_data_sources", "database_strategy_type", "database_sharding_column", "database_sharding_algorithm_type", "database_sharding_algorithm_props", "table_strategy_type", "table_sharding_column", "table_sharding_algorithm_type", "table_sharding_algorithm_props", "key_generate_column", "key_generator_type", "key_generator_props", "auditor_types", "allow_hint_disable");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShardingTableRulesStatement sqlStatement, ContextManager contextManager) {
        Collection autoTables;
        Collection tables;
        String tableName = sqlStatement.getTableName();
        if (null == tableName) {
            tables = this.rule.getConfiguration().getTables();
            autoTables = this.rule.getConfiguration().getAutoTables();
        } else {
            tables = this.rule.getConfiguration().getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList());
            autoTables = this.rule.getConfiguration().getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList());
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (ShardingTableRuleConfiguration each2 : tables) {
            result.add(this.buildTableRowData(this.rule.getConfiguration(), each2));
        }
        for (ShardingTableRuleConfiguration each2 : autoTables) {
            result.add(this.buildAutoTableRowData(this.rule.getConfiguration(), (ShardingAutoTableRuleConfiguration)each2));
        }
        return result;
    }

    private LocalDataQueryResultRow buildTableRowData(ShardingRuleConfiguration ruleConfig, ShardingTableRuleConfiguration shardingTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> databaseShardingStrategyConfig = this.getDatabaseShardingStrategy(ruleConfig, shardingTableRuleConfig);
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(ruleConfig, shardingTableRuleConfig.getTableShardingStrategy());
        return new LocalDataQueryResultRow(new Object[]{shardingTableRuleConfig.getLogicTable(), shardingTableRuleConfig.getActualDataNodes(), "", databaseShardingStrategyConfig.map(this::getStrategyType), databaseShardingStrategyConfig.map(this::getShardingColumn), databaseShardingStrategyConfig.map(optional -> this.getAlgorithmType(ruleConfig, (ShardingStrategyConfiguration)optional)), databaseShardingStrategyConfig.map(optional -> this.getAlgorithmProperties(ruleConfig, (ShardingStrategyConfiguration)optional)), tableShardingStrategyConfig.map(this::getStrategyType).orElse(""), tableShardingStrategyConfig.map(this::getShardingColumn), tableShardingStrategyConfig.map(optional -> this.getAlgorithmType(ruleConfig, (ShardingStrategyConfiguration)optional)), tableShardingStrategyConfig.map(optional -> this.getAlgorithmProperties(ruleConfig, (ShardingStrategyConfiguration)optional)), this.getKeyGenerateColumn(ruleConfig, shardingTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorType(ruleConfig, shardingTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorProps(ruleConfig, shardingTableRuleConfig.getKeyGenerateStrategy()), this.getAuditorTypes(ruleConfig, shardingTableRuleConfig.getAuditStrategy()), this.getAllowHintDisable(ruleConfig, shardingTableRuleConfig.getAuditStrategy())});
    }

    private LocalDataQueryResultRow buildAutoTableRowData(ShardingRuleConfiguration ruleConfig, ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(ruleConfig, shardingAutoTableRuleConfig.getShardingStrategy());
        return new LocalDataQueryResultRow(new Object[]{shardingAutoTableRuleConfig.getLogicTable(), "", shardingAutoTableRuleConfig.getActualDataSources(), "", "", "", "", tableShardingStrategyConfig.map(this::getStrategyType), tableShardingStrategyConfig.map(this::getShardingColumn), tableShardingStrategyConfig.map(optional -> this.getAlgorithmType(ruleConfig, (ShardingStrategyConfiguration)optional)), tableShardingStrategyConfig.map(optional -> this.getAlgorithmProperties(ruleConfig, (ShardingStrategyConfiguration)optional)), this.getKeyGenerateColumn(ruleConfig, shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorType(ruleConfig, shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorProps(ruleConfig, shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getAuditorTypes(ruleConfig, shardingAutoTableRuleConfig.getAuditStrategy()), this.getAllowHintDisable(ruleConfig, shardingAutoTableRuleConfig.getAuditStrategy())});
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            return ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            return ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        return "";
    }

    private String getAlgorithmType(ShardingRuleConfiguration ruleConfig, ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? "" : this.getAlgorithmConfiguration(ruleConfig, shardingStrategyConfig.getShardingAlgorithmName()).getType();
    }

    private Properties getAlgorithmProperties(ShardingRuleConfiguration ruleConfig, ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? new Properties() : this.getAlgorithmConfiguration(ruleConfig, shardingStrategyConfig.getShardingAlgorithmName()).getProps();
    }

    private Optional<ShardingStrategyConfiguration> getDatabaseShardingStrategy(ShardingRuleConfiguration ruleConfig, ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return null == shardingTableRuleConfig.getDatabaseShardingStrategy() ? Optional.ofNullable(ruleConfig.getDefaultDatabaseShardingStrategy()) : Optional.of(shardingTableRuleConfig.getDatabaseShardingStrategy());
    }

    private AlgorithmConfiguration getAlgorithmConfiguration(ShardingRuleConfiguration ruleConfig, String algorithmName) {
        return (AlgorithmConfiguration)ruleConfig.getShardingAlgorithms().get(algorithmName);
    }

    private String getStrategyType(ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig.getType();
    }

    private Optional<ShardingStrategyConfiguration> getTableShardingStrategy(ShardingRuleConfiguration ruleConfig, ShardingStrategyConfiguration shardingStrategyConfig) {
        return null == shardingStrategyConfig ? Optional.ofNullable(ruleConfig.getDefaultTableShardingStrategy()) : Optional.of(shardingStrategyConfig);
    }

    private String getKeyGenerateColumn(ShardingRuleConfiguration ruleConfig, KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(ruleConfig, keyGenerateStrategyConfig).isPresent() ? this.getKeyGenerateStrategyConfiguration(ruleConfig, keyGenerateStrategyConfig).get().getColumn() : "";
    }

    private String getKeyGeneratorType(ShardingRuleConfiguration ruleConfig, KeyGenerateStrategyConfiguration originalKeyGenerateStrategyConfig) {
        Optional<KeyGenerateStrategyConfiguration> keyGenerateStrategyConfig = this.getKeyGenerateStrategyConfiguration(ruleConfig, originalKeyGenerateStrategyConfig);
        return keyGenerateStrategyConfig.isPresent() ? ((AlgorithmConfiguration)ruleConfig.getKeyGenerators().get(keyGenerateStrategyConfig.get().getKeyGeneratorName())).getType() : "";
    }

    private Properties getKeyGeneratorProps(ShardingRuleConfiguration ruleConfig, KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(ruleConfig, keyGenerateStrategyConfig).map(optional -> ((AlgorithmConfiguration)ruleConfig.getKeyGenerators().get(optional.getKeyGeneratorName())).getProps()).orElse(new Properties());
    }

    private Optional<KeyGenerateStrategyConfiguration> getKeyGenerateStrategyConfiguration(ShardingRuleConfiguration ruleConfig, KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return null == keyGenerateStrategyConfig ? Optional.ofNullable(ruleConfig.getDefaultKeyGenerateStrategy()) : Optional.of(keyGenerateStrategyConfig);
    }

    private String getAuditorTypes(ShardingRuleConfiguration ruleConfig, ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        Optional<ShardingAuditStrategyConfiguration> auditStrategyConfig = this.getShardingAuditStrategyConfiguration(ruleConfig, shardingAuditStrategyConfig);
        LinkedList<String> auditorTypes = new LinkedList<String>();
        if (auditStrategyConfig.isPresent()) {
            for (String each : auditStrategyConfig.get().getAuditorNames()) {
                auditorTypes.add(((AlgorithmConfiguration)ruleConfig.getAuditors().get(each)).getType());
            }
        }
        return auditorTypes.isEmpty() ? "" : String.join((CharSequence)",", auditorTypes);
    }

    private String getAllowHintDisable(ShardingRuleConfiguration ruleConfig, ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        return this.getShardingAuditStrategyConfiguration(ruleConfig, shardingAuditStrategyConfig).isPresent() ? Boolean.toString(this.getShardingAuditStrategyConfiguration(ruleConfig, shardingAuditStrategyConfig).get().isAllowHintDisable()) : "";
    }

    private Optional<ShardingAuditStrategyConfiguration> getShardingAuditStrategyConfiguration(ShardingRuleConfiguration ruleConfig, ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        return null == shardingAuditStrategyConfig ? Optional.ofNullable(ruleConfig.getDefaultAuditStrategy()) : Optional.of(shardingAuditStrategyConfig);
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowShardingTableRulesStatement> getType() {
        return ShowShardingTableRulesStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

