/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.executor.item;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.executor.item.JobItemExecutor;
import org.apache.shardingsphere.elasticjob.executor.item.impl.ClassedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.executor.item.impl.TypedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;

public final class JobItemExecutorFactory {
    private static final Map<Class, ClassedJobItemExecutor> CLASSED_EXECUTORS = new HashMap<Class, ClassedJobItemExecutor>();

    public static JobItemExecutor getExecutor(Class<? extends ElasticJob> elasticJobClass) {
        for (Map.Entry<Class, ClassedJobItemExecutor> entry : CLASSED_EXECUTORS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(elasticJobClass)) continue;
            return entry.getValue();
        }
        throw new JobConfigurationException("Can not find executor for elastic job class `%s`", new Object[]{elasticJobClass.getName()});
    }

    public static JobItemExecutor getExecutor(String elasticJobType) {
        return (JobItemExecutor)ElasticJobServiceLoader.getCachedTypedServiceInstance(TypedJobItemExecutor.class, (String)elasticJobType).orElseThrow(() -> new JobConfigurationException("Cannot find executor for elastic job type `%s`", new Object[]{elasticJobType}));
    }

    @Generated
    private JobItemExecutorFactory() {
    }

    static {
        ElasticJobServiceLoader.registerTypedService(TypedJobItemExecutor.class);
        ServiceLoader.load(ClassedJobItemExecutor.class).forEach(each -> CLASSED_EXECUTORS.put(each.getElasticJobClass(), (ClassedJobItemExecutor)each));
    }
}

