/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import org.apache.shardingsphere.shade.okhttp3.MediaType;
import org.apache.shardingsphere.shade.okhttp3.RequestBody;
import org.apache.shardingsphere.shade.okio.BufferedSink;
import org.apache.shardingsphere.shade.zipkin2.reporter.Encoding;

enum RequestBodyMessageEncoder {
    JSON{

        @Override
        public RequestBody encode(List<byte[]> encodedSpans) {
            return new JsonRequestBody(encodedSpans);
        }
    }
    ,
    THRIFT{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new ThriftRequestBody(encodedSpans);
        }
    }
    ,
    PROTO3{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new Protobuf3RequestBody(encodedSpans);
        }
    };


    static RequestBodyMessageEncoder forEncoding(Encoding encoding) {
        switch (encoding) {
            case JSON: {
                return JSON;
            }
            case THRIFT: {
                return THRIFT;
            }
            case PROTO3: {
                return PROTO3;
            }
        }
        throw new UnsupportedOperationException("Unsupported encoding: " + encoding.name());
    }

    abstract RequestBody encode(List<byte[]> var1);

    static final class Protobuf3RequestBody
    extends StreamingRequestBody {
        Protobuf3RequestBody(List<byte[]> values2) {
            super(Encoding.PROTO3, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
            }
        }
    }

    static final class ThriftRequestBody
    extends StreamingRequestBody {
        ThriftRequestBody(List<byte[]> values2) {
            super(Encoding.THRIFT, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            int length = this.values.size();
            sink2.writeByte(12);
            sink2.writeByte(length >>> 24 & 0xFF);
            sink2.writeByte(length >>> 16 & 0xFF);
            sink2.writeByte(length >>> 8 & 0xFF);
            sink2.writeByte(length & 0xFF);
            int i = 0;
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
            }
        }
    }

    static final class JsonRequestBody
    extends StreamingRequestBody {
        JsonRequestBody(List<byte[]> values2) {
            super(Encoding.JSON, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            sink2.writeByte(91);
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
                if (i >= length) continue;
                sink2.writeByte(44);
            }
            sink2.writeByte(93);
        }
    }

    static abstract class StreamingRequestBody
    extends RequestBody {
        final MediaType contentType;
        final List<byte[]> values;
        final long contentLength;

        StreamingRequestBody(Encoding encoding, List<byte[]> values2) {
            this.contentType = MediaType.parse(encoding.mediaType());
            this.values = values2;
            this.contentLength = encoding.listSizeInBytes(values2);
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }
    }
}

