/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.zipkin2.reporter;

import org.apache.shardingsphere.shade.zipkin2.Span;
import org.apache.shardingsphere.shade.zipkin2.reporter.BytesEncoder;
import org.apache.shardingsphere.shade.zipkin2.reporter.Encoding;

public enum SpanBytesEncoder implements BytesEncoder<Span>
{
    THRIFT{

        @Override
        public Encoding encoding() {
            return Encoding.THRIFT;
        }

        @Override
        public int sizeInBytes(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.THRIFT.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.THRIFT.encode(input);
        }
    }
    ,
    JSON_V1{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.JSON_V1.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.JSON_V1.encode(input);
        }
    }
    ,
    JSON_V2{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.JSON_V2.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.JSON_V2.encode(input);
        }
    }
    ,
    PROTO3{

        @Override
        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        @Override
        public int sizeInBytes(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.PROTO3.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span input) {
            return org.apache.shardingsphere.shade.zipkin2.codec.SpanBytesEncoder.PROTO3.encode(input);
        }
    };


    public static BytesEncoder<Span> forEncoding(Encoding encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding == null");
        }
        switch (encoding) {
            case JSON: {
                return JSON_V2;
            }
            case PROTO3: {
                return PROTO3;
            }
            case THRIFT: {
                return THRIFT;
            }
        }
        throw new UnsupportedOperationException("BUG: " + encoding.name());
    }
}

