/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs;

import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.logs.ExtendedLogger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.LogRecordBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.LoggerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LoggerSharedState;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal.LoggerConfig;

final class SdkLogger
implements ExtendedLogger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get("noop");
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean loggerEnabled;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerEnabled) {
            return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public boolean isEnabled() {
        return this.loggerEnabled;
    }
}

