/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.logs.AnyValue;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.BytesAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;

public final class AnyValueMarshaler {
    private AnyValueMarshaler() {
    }

    public static MarshalerWithSize create(AnyValue<?> anyValue) {
        switch (anyValue.getType()) {
            case STRING: {
                return StringAnyValueMarshaler.create((String)anyValue.getValue());
            }
            case BOOLEAN: {
                return BoolAnyValueMarshaler.create((Boolean)anyValue.getValue());
            }
            case LONG: {
                return IntAnyValueMarshaler.create((Long)anyValue.getValue());
            }
            case DOUBLE: {
                return DoubleAnyValueMarshaler.create((Double)anyValue.getValue());
            }
            case ARRAY: {
                return ArrayAnyValueMarshaler.createAnyValue((List)anyValue.getValue());
            }
            case KEY_VALUE_LIST: {
                return KeyValueListAnyValueMarshaler.create((List)anyValue.getValue());
            }
            case BYTES: {
                return BytesAnyValueMarshaler.create((ByteBuffer)anyValue.getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported AnyValue type: " + (Object)((Object)anyValue.getType()));
    }
}

