/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDistributedBarrier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDistributedBarrier.class);
    private static final Map<PipelineContextKey, PipelineDistributedBarrier> INSTANCE_MAP = new ConcurrentHashMap<PipelineContextKey, PipelineDistributedBarrier>();
    private final PipelineContextKey contextKey;
    private final LazyInitializer<ClusterPersistRepository> repositoryLazyInitializer = new PersistRepositoryLazyInitializer();
    private final Map<String, InnerCountDownLatchHolder> countDownLatchHolders = new ConcurrentHashMap<String, InnerCountDownLatchHolder>();

    public static PipelineDistributedBarrier getInstance(PipelineContextKey contextKey) {
        PipelineDistributedBarrier result = INSTANCE_MAP.get(contextKey);
        if (null != result) {
            return result;
        }
        INSTANCE_MAP.computeIfAbsent(contextKey, PipelineDistributedBarrier::new);
        return INSTANCE_MAP.get(contextKey);
    }

    private ClusterPersistRepository getRepository() {
        return (ClusterPersistRepository)this.repositoryLazyInitializer.get();
    }

    public void register(String barrierPath, int totalCount) {
        this.getRepository().persist(barrierPath, "");
        this.countDownLatchHolders.computeIfAbsent(barrierPath, key -> new InnerCountDownLatchHolder(totalCount, new CountDownLatch(1)));
    }

    public void persistEphemeralChildrenNode(String barrierPath, int shardingItem) {
        if (!this.getRepository().isExisted(barrierPath)) {
            return;
        }
        String key = String.join((CharSequence)"/", barrierPath, Integer.toString(shardingItem));
        this.getRepository().delete(key);
        this.getRepository().persistEphemeral(key, "");
    }

    public void unregister(String barrierPath) {
        this.getRepository().delete(barrierPath);
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.remove(barrierPath);
        if (null != holder) {
            holder.getCountDownLatch().countDown();
        }
    }

    public boolean await(String barrierPath, long timeout, TimeUnit timeUnit) {
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.get(barrierPath);
        if (null == holder) {
            return false;
        }
        try {
            boolean result = holder.getCountDownLatch().await(timeout, timeUnit);
            if (!result) {
                log.info("await timeout, barrier path: {}, timeout: {}, time unit: {}", new Object[]{barrierPath, timeout, timeUnit});
            }
            return result;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void notifyChildrenNodeCountCheck(String nodePath) {
        if (Strings.isNullOrEmpty((String)nodePath)) {
            return;
        }
        String barrierPath = nodePath.substring(0, nodePath.lastIndexOf(47));
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.get(barrierPath);
        if (null != holder && this.getRepository().getChildrenKeys(barrierPath).size() == holder.getTotalCount()) {
            holder.getCountDownLatch().countDown();
        }
    }

    @Generated
    private PipelineDistributedBarrier(PipelineContextKey contextKey) {
        this.contextKey = contextKey;
    }

    private static class InnerCountDownLatchHolder {
        private final int totalCount;
        private final CountDownLatch countDownLatch;

        @Generated
        public InnerCountDownLatchHolder(int totalCount, CountDownLatch countDownLatch) {
            this.totalCount = totalCount;
            this.countDownLatch = countDownLatch;
        }

        @Generated
        public int getTotalCount() {
            return this.totalCount;
        }

        @Generated
        public CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }
    }

    private final class PersistRepositoryLazyInitializer
    extends LazyInitializer<ClusterPersistRepository> {
        protected ClusterPersistRepository initialize() {
            return (ClusterPersistRepository)PipelineContextManager.getContext(PipelineDistributedBarrier.this.contextKey).getContextManager().getPersistServiceFacade().getMetaDataPersistService().getRepository();
        }

        @Generated
        public PersistRepositoryLazyInitializer() {
        }
    }
}

