/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.item;

import com.google.common.base.Strings;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class PipelineJobItemProcessGovernanceRepository {
    private final ClusterPersistRepository repository;

    public void persist(String jobId, int shardingItem, String progressValue) {
        this.repository.persist(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem), progressValue);
    }

    public void update(String jobId, int shardingItem, String progressValue) {
        this.repository.update(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem), progressValue);
    }

    public Optional<String> load(String jobId, int shardingItem) {
        String text = this.repository.query(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem));
        return Strings.isNullOrEmpty((String)text) ? Optional.empty() : Optional.of(text);
    }

    @Generated
    public PipelineJobItemProcessGovernanceRepository(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

