/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.channel.InventoryChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.importer.SingleChannelConsumerImporter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.InventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.type.PlaceholderInventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.type.UniqueKeyInventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter.InventoryDumperContextSplitter;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);
    private final PipelineDataSource sourceDataSource;
    private final InventoryDumperContext dumperContext;
    private final ImporterConfiguration importerConfig;

    public List<InventoryTask> split(TransmissionJobItemContext jobItemContext) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        long startTimeMillis = System.currentTimeMillis();
        TransmissionProcessContext processContext = jobItemContext.getJobProcessContext();
        InventoryDumperContextSplitter dumperContextSplitter = new InventoryDumperContextSplitter(this.sourceDataSource, this.dumperContext);
        for (InventoryDumperContext each : dumperContextSplitter.split(jobItemContext)) {
            AtomicReference<IngestPosition> position = new AtomicReference<IngestPosition>(each.getCommonContext().getPosition());
            PipelineChannel channel = InventoryChannelCreator.create(processContext.getProcessConfiguration().getStreamChannel(), this.importerConfig.getBatchSize(), position);
            InventoryDataRecordPositionCreator positionCreator = each.hasUniqueKey() ? new UniqueKeyInventoryDataRecordPositionCreator() : new PlaceholderInventoryDataRecordPositionCreator();
            InventoryDumper dumper = new InventoryDumper(each, channel, this.sourceDataSource, jobItemContext.getSourceMetaDataLoader(), positionCreator);
            SingleChannelConsumerImporter importer = new SingleChannelConsumerImporter(channel, this.importerConfig.getBatchSize(), 3000L, jobItemContext.getSink(), jobItemContext);
            result.add(new InventoryTask(PipelineTaskUtils.generateInventoryTaskId(each), processContext.getInventoryDumperExecuteEngine(), processContext.getInventoryImporterExecuteEngine(), dumper, importer, position));
        }
        log.info("Split inventory tasks cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
        return result;
    }

    @Generated
    public InventoryTaskSplitter(PipelineDataSource sourceDataSource, InventoryDumperContext dumperContext, ImporterConfiguration importerConfig) {
        this.sourceDataSource = sourceDataSource;
        this.dumperContext = dumperContext;
        this.importerConfig = importerConfig;
    }
}

