/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineMetaDataPersistService;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class PipelineDataSourcePersistService
implements PipelineMetaDataPersistService<Map<String, DataSourcePoolProperties>> {
    private final YamlDataSourceConfigurationSwapper swapper = new YamlDataSourceConfigurationSwapper();

    @Override
    public Map<String, DataSourcePoolProperties> load(PipelineContextKey contextKey, String jobType) {
        String dataSourcesProps = PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).getMetaDataFacade().getDataSource().load(jobType);
        if (Strings.isNullOrEmpty((String)dataSourcesProps)) {
            return Collections.emptyMap();
        }
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)dataSourcesProps, Map.class);
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(yamlDataSources.size(), 1.0f);
        yamlDataSources.forEach((key, value) -> result.put((String)key, this.swapper.swapToDataSourcePoolProperties(value)));
        return result;
    }

    @Override
    public void persist(PipelineContextKey contextKey, String jobType, Map<String, DataSourcePoolProperties> propsMap) {
        LinkedHashMap<String, Map> dataSourceMap = new LinkedHashMap<String, Map>(propsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            dataSourceMap.put(entry.getKey(), this.swapper.swapToMap(entry.getValue()));
        }
        PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).getMetaDataFacade().getDataSource().persist(jobType, YamlEngine.marshal(dataSourceMap));
    }
}

