/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.type;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class JobCodeRegistry {
    private static final Map<String, PipelineJobType> JOB_CODE_AND_TYPE_MAP = new HashMap<String, PipelineJobType>();

    public static PipelineJobType getJobType(String jobTypeCode) {
        Preconditions.checkArgument((boolean)JOB_CODE_AND_TYPE_MAP.containsKey(jobTypeCode), (String)"Can not get job type by `%s`.", (Object)jobTypeCode);
        return JOB_CODE_AND_TYPE_MAP.get(jobTypeCode);
    }

    @Generated
    private JobCodeRegistry() {
    }

    static {
        for (PipelineJobType each : ShardingSphereServiceLoader.getServiceInstances(PipelineJobType.class)) {
            Preconditions.checkArgument((2 == each.getCode().length() ? 1 : 0) != 0, (Object)"Job type code length is not 2.");
            JOB_CODE_AND_TYPE_MAP.put(each.getCode(), each);
        }
    }
}

