/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.exception.data;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.PipelineSQLException;

public abstract class PipelineDataException
extends PipelineSQLException {
    private static final long serialVersionUID = -4353142247923068753L;
    private static final int JOB_CODE = 2;

    protected PipelineDataException(SQLState sqlState, int errorCode, String reason) {
        super(sqlState, PipelineDataException.getErrorCode(errorCode), reason);
    }

    protected PipelineDataException(SQLState sqlState, int errorCode, String reason, Exception cause) {
        super(sqlState, PipelineDataException.getErrorCode(errorCode), reason, cause);
    }

    private static int getErrorCode(int errorCode) {
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 100 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 100).");
        return 200 + errorCode;
    }
}

