/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.range.QueryRange;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class SingleTableInventoryCalculateParameter {
    private final PipelineDataSource dataSource;
    private final QualifiedTable table;
    private final List<String> columnNames;
    private final List<PipelineColumnMetaData> uniqueKeys;
    private final AtomicReference<AutoCloseable> calculationContext = new AtomicReference();
    private final AtomicReference<Collection<Object>> uniqueKeysValues = new AtomicReference();
    private final AtomicReference<QueryRange> uniqueKeysValuesRange = new AtomicReference();
    private final AtomicReference<List<String>> shardingColumnsNames = new AtomicReference();
    private final AtomicReference<List<Object>> shardingColumnsValues = new AtomicReference();
    private final QueryType queryType;

    public SingleTableInventoryCalculateParameter(PipelineDataSource dataSource, QualifiedTable table, List<String> columnNames, List<PipelineColumnMetaData> uniqueKeys, Object tableCheckPosition) {
        this.dataSource = dataSource;
        this.table = table;
        this.columnNames = columnNames;
        this.uniqueKeys = uniqueKeys;
        this.queryType = QueryType.RANGE_QUERY;
        this.setQueryRange(new QueryRange(tableCheckPosition, false, null));
    }

    public DatabaseType getDatabaseType() {
        return this.dataSource.getDatabaseType();
    }

    public PipelineColumnMetaData getFirstUniqueKey() {
        return this.uniqueKeys.get(0);
    }

    public AutoCloseable getCalculationContext() {
        return this.calculationContext.get();
    }

    public void setCalculationContext(AutoCloseable calculationContext) {
        this.calculationContext.set(calculationContext);
    }

    public List<String> getUniqueKeysNames() {
        return this.uniqueKeys.stream().map(PipelineColumnMetaData::getName).collect(Collectors.toList());
    }

    public Collection<Object> getUniqueKeysValues() {
        return this.uniqueKeysValues.get();
    }

    public void setUniqueKeysValues(Collection<Object> uniqueKeysValues) {
        this.uniqueKeysValues.set(uniqueKeysValues);
    }

    public QueryRange getQueryRange() {
        return this.uniqueKeysValuesRange.get();
    }

    public void setQueryRange(QueryRange queryRange) {
        this.uniqueKeysValuesRange.set(queryRange);
    }

    @Nullable
    public List<String> getShardingColumnsNames() {
        return this.shardingColumnsNames.get();
    }

    public void setShardingColumnsNames(List<String> shardingColumnsNames) {
        this.shardingColumnsNames.set(shardingColumnsNames);
    }

    @Nullable
    public List<Object> getShardingColumnsValues() {
        return this.shardingColumnsValues.get();
    }

    public void setShardingColumnsValues(List<Object> shardingColumnsValues) {
        this.shardingColumnsValues.set(shardingColumnsValues);
    }

    @Generated
    public SingleTableInventoryCalculateParameter(PipelineDataSource dataSource, QualifiedTable table, List<String> columnNames, List<PipelineColumnMetaData> uniqueKeys, QueryType queryType) {
        this.dataSource = dataSource;
        this.table = table;
        this.columnNames = columnNames;
        this.uniqueKeys = uniqueKeys;
        this.queryType = queryType;
    }

    @Generated
    public PipelineDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public QualifiedTable getTable() {
        return this.table;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<PipelineColumnMetaData> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Generated
    public AtomicReference<QueryRange> getUniqueKeysValuesRange() {
        return this.uniqueKeysValuesRange;
    }

    @Generated
    public QueryType getQueryType() {
        return this.queryType;
    }
}

