/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.MatchingTableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.CRC32SingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculator;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.spi.annotation.SPIDescription;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

@SPIDescription(value="Match CRC32 of records.")
public final class CRC32MatchTableDataConsistencyChecker
implements TableDataConsistencyChecker {
    @Override
    public TableInventoryChecker buildTableInventoryChecker(TableInventoryCheckParameter param) {
        return new CRC32MatchTableInventoryChecker(param);
    }

    public Collection<DatabaseType> getSupportedDatabaseTypes() {
        LinkedList<DatabaseType> result = new LinkedList<DatabaseType>();
        DatabaseType supportedDatabaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");
        result.add(supportedDatabaseType);
        result.addAll(new DatabaseTypeRegistry(supportedDatabaseType).getAllBranchDatabaseTypes());
        return result;
    }

    @Override
    public void close() {
    }

    public String getType() {
        return "CRC32_MATCH";
    }

    private static final class CRC32MatchTableInventoryChecker
    extends MatchingTableInventoryChecker {
        CRC32MatchTableInventoryChecker(TableInventoryCheckParameter param) {
            super(param);
        }

        @Override
        protected SingleTableInventoryCalculator buildSingleTableInventoryCalculator() {
            return new CRC32SingleTableInventoryCalculator();
        }
    }
}

