/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.channel.memory;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannelAckCallback;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;

public final class MemoryPipelineChannel
implements PipelineChannel {
    private final BlockingQueue<List<Record>> queue;
    private final PipelineChannelAckCallback ackCallback;

    public MemoryPipelineChannel(int blockQueueSize, PipelineChannelAckCallback ackCallback) {
        this.queue = blockQueueSize < 1 ? new SynchronousQueue(true) : new ArrayBlockingQueue(blockQueueSize, true);
        this.ackCallback = ackCallback;
    }

    @Override
    public void push(List<Record> records) {
        this.queue.put(records);
    }

    @Override
    public List<Record> fetch(int batchSize, long timeoutMillis) {
        LinkedList<Record> result = new LinkedList<Record>();
        long startMillis = System.currentTimeMillis();
        int recordsCount = 0;
        do {
            List<Record> records;
            if (null == (records = this.queue.poll(Math.max(0L, timeoutMillis - (System.currentTimeMillis() - startMillis)), TimeUnit.MILLISECONDS)) || records.isEmpty()) continue;
            recordsCount += records.size();
            result.addAll(records);
        } while (recordsCount < batchSize && System.currentTimeMillis() - startMillis < timeoutMillis);
        return result;
    }

    @Override
    public List<Record> peek() {
        List result = (List)this.queue.peek();
        return null == result ? Collections.emptyList() : result;
    }

    @Override
    public List<Record> poll() {
        List result = (List)this.queue.poll();
        return null == result ? Collections.emptyList() : result;
    }

    @Override
    public void ack(List<Record> records) {
        this.ackCallback.onAck(records);
    }
}

