/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.distsql.handler.update;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.distsql.statement.updatable.AlterTransactionRuleStatement;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;

public final class AlterTransactionRuleExecutor
implements GlobalRuleDefinitionExecutor<AlterTransactionRuleStatement, TransactionRule> {
    public void checkBeforeUpdate(AlterTransactionRuleStatement sqlStatement) {
        this.checkTransactionType(sqlStatement);
        TransactionType transactionType = TransactionType.valueOf((String)sqlStatement.getDefaultType().toUpperCase());
        if (TransactionType.LOCAL != transactionType) {
            this.checkTransactionManager(sqlStatement, transactionType);
        }
    }

    private void checkTransactionType(AlterTransactionRuleStatement statement) {
        try {
            TransactionType.valueOf((String)statement.getDefaultType().toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidRuleConfigurationException("Transaction", String.format("Unsupported transaction type `%s`", statement.getDefaultType()));
        }
    }

    private void checkTransactionManager(AlterTransactionRuleStatement statement, TransactionType transactionType) {
        Collection distributedTransactionManagers = ShardingSphereServiceLoader.getServiceInstances(ShardingSphereDistributedTransactionManager.class);
        Optional<ShardingSphereDistributedTransactionManager> distributedTransactionManager = distributedTransactionManagers.stream().filter(each -> transactionType == each.getTransactionType()).findFirst();
        ShardingSpherePreconditions.checkState((boolean)distributedTransactionManager.isPresent(), () -> new InvalidRuleConfigurationException("Transaction", String.format("No transaction manager with type `%s`", statement.getDefaultType())));
        if (TransactionType.XA == transactionType) {
            this.checkTransactionManagerProviderType(distributedTransactionManager.get(), statement.getProvider().getProviderType());
        }
    }

    private void checkTransactionManagerProviderType(ShardingSphereDistributedTransactionManager distributedTransactionManager, String providerType) {
        ShardingSpherePreconditions.checkState((boolean)distributedTransactionManager.containsProviderType(providerType), () -> new InvalidRuleConfigurationException("Transaction", String.format("No transaction manager provider with type `%s`", providerType)));
    }

    public TransactionRuleConfiguration buildToBeAlteredRuleConfiguration(AlterTransactionRuleStatement sqlStatement) {
        return new TransactionRuleConfiguration(sqlStatement.getDefaultType(), sqlStatement.getProvider().getProviderType(), sqlStatement.getProvider().getProps());
    }

    public void setRule(TransactionRule rule) {
    }

    public Class<TransactionRule> getRuleClass() {
        return TransactionRule.class;
    }

    public Class<AlterTransactionRuleStatement> getType() {
        return AlterTransactionRuleStatement.class;
    }
}

