/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rql.resource;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.handler.executor.rql.resource.InUsedStorageUnitRetriever;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.ShowRulesUsedStorageUnitStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowRulesUsedStorageUnitExecutor
implements DistSQLQueryExecutor<ShowRulesUsedStorageUnitStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    @Override
    public Collection<String> getColumnNames(ShowRulesUsedStorageUnitStatement sqlStatement) {
        return Arrays.asList("type", "name");
    }

    @Override
    public Collection<LocalDataQueryResultRow> getRows(ShowRulesUsedStorageUnitStatement sqlStatement, ContextManager contextManager) {
        String resourceName = sqlStatement.getStorageUnitName().orElse(null);
        return this.database.getResourceMetaData().getStorageUnits().containsKey(resourceName) ? this.getRows(sqlStatement) : Collections.emptyList();
    }

    private Collection<LocalDataQueryResultRow> getRows(ShowRulesUsedStorageUnitStatement sqlStatement) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (InUsedStorageUnitRetriever each : ShardingSphereServiceLoader.getServiceInstances(InUsedStorageUnitRetriever.class)) {
            this.database.getRuleMetaData().findSingleRule((Class)each.getType()).ifPresent(optional -> result.addAll(this.getRows(sqlStatement, (ShardingSphereRule)optional, each)));
        }
        return result;
    }

    private Collection<LocalDataQueryResultRow> getRows(ShowRulesUsedStorageUnitStatement sqlStatement, ShardingSphereRule rule, InUsedStorageUnitRetriever<ShardingSphereRule> retriever) {
        String type = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ((Class)retriever.getType()).getSimpleName().substring(0, ((Class)retriever.getType()).getSimpleName().indexOf("Rule")));
        return retriever.getInUsedResources(sqlStatement, rule).stream().map(each -> new LocalDataQueryResultRow(new Object[]{type, each})).collect(Collectors.toList());
    }

    @Override
    public Class<ShowRulesUsedStorageUnitStatement> getType() {
        return ShowRulesUsedStorageUnitStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

