/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.settings;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class JobConfigurationAPIImpl
implements JobConfigurationAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public JobConfigurationPOJO getJobConfiguration(String jobName) {
        String yamlContent = this.regCenter.get(new JobNodePath(jobName).getConfigNodePath());
        if (null == yamlContent) {
            return null;
        }
        return (JobConfigurationPOJO)YamlEngine.unmarshal((String)yamlContent, JobConfigurationPOJO.class);
    }

    @Override
    public void updateJobConfiguration(JobConfigurationPOJO jobConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobConfig.getJobName()) ? 1 : 0) != 0, (Object)"jobName can not be empty.");
        Preconditions.checkArgument((jobConfig.getShardingTotalCount() > 0 ? 1 : 0) != 0, (Object)"shardingTotalCount should larger than zero.");
        JobNodePath jobNodePath = new JobNodePath(jobConfig.getJobName());
        this.regCenter.update(jobNodePath.getConfigNodePath(), YamlEngine.marshal((Object)jobConfig));
    }

    @Override
    public void removeJobConfiguration(String jobName) {
        this.regCenter.remove("/" + jobName);
    }

    @Generated
    public JobConfigurationAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

