/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.NamedRuleItemChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.UniqueRuleItemChangedHandler;
import org.apache.shardingsphere.mode.node.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.node.path.rule.item.NamedRuleItemNodePath;
import org.apache.shardingsphere.mode.node.path.rule.item.UniqueRuleItemNodePath;
import org.apache.shardingsphere.mode.node.spi.RuleNodePathProvider;

public final class RuleConfigurationChangedHandler {
    private final NamedRuleItemChangedHandler namedRuleItemChangedHandler;
    private final UniqueRuleItemChangedHandler uniqueRuleItemChangedHandler;

    public RuleConfigurationChangedHandler(ContextManager contextManager) {
        this.namedRuleItemChangedHandler = new NamedRuleItemChangedHandler(contextManager);
        this.uniqueRuleItemChangedHandler = new UniqueRuleItemChangedHandler(contextManager);
    }

    public void handle(String databaseName, DataChangedEvent event) throws SQLException {
        for (RuleNodePathProvider each : ShardingSphereServiceLoader.getServiceInstances(RuleNodePathProvider.class)) {
            if (!this.handle(each.getRuleNodePath(), databaseName, event)) continue;
            return;
        }
    }

    private boolean handle(RuleNodePath ruleNodePath, String databaseName, DataChangedEvent event) throws SQLException {
        if (!ruleNodePath.getRoot().isValidatedPath(event.getKey()) || DataChangedEvent.Type.DELETED != event.getType() && Strings.isNullOrEmpty((String)event.getValue())) {
            return false;
        }
        return this.handleNamedRuleItems(ruleNodePath, databaseName, event) || this.handleUniqueRuleItems(ruleNodePath, databaseName, event);
    }

    private boolean handleNamedRuleItems(RuleNodePath ruleNodePath, String databaseName, DataChangedEvent event) throws SQLException {
        for (Map.Entry entry : ruleNodePath.getNamedItems().entrySet()) {
            Optional<String> itemName = this.getItemName(event, (NamedRuleItemNodePath)entry.getValue());
            if (!itemName.isPresent()) continue;
            this.namedRuleItemChangedHandler.handle(ruleNodePath, databaseName, itemName.get(), (String)entry.getKey(), event);
            return true;
        }
        return false;
    }

    private boolean handleUniqueRuleItems(RuleNodePath ruleNodePath, String databaseName, DataChangedEvent event) throws SQLException {
        for (Map.Entry entry : ruleNodePath.getUniqueItems().entrySet()) {
            if (!((UniqueRuleItemNodePath)entry.getValue()).isActiveVersionPath(event.getKey())) continue;
            this.uniqueRuleItemChangedHandler.handle(ruleNodePath, databaseName, (String)entry.getKey(), event);
            return true;
        }
        return false;
    }

    private Optional<String> getItemName(DataChangedEvent event, NamedRuleItemNodePath ruleItemNodePath) {
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return ruleItemNodePath.getNameByActiveVersion(event.getKey());
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return ruleItemNodePath.getNameByItemPath(event.getKey());
        }
        return Optional.empty();
    }
}

