/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;

public final class SchemaChangedHandler {
    private final ContextManager contextManager;
    private final ShardingSphereStatisticsRefreshEngine statisticsRefreshEngine;

    public SchemaChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new ShardingSphereStatisticsRefreshEngine(contextManager);
    }

    public void handleCreated(String databaseName, String schemaName) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().addSchema(databaseName, schemaName);
        this.statisticsRefreshEngine.asyncRefresh();
    }

    public void handleDropped(String databaseName, String schemaName) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().dropSchema(databaseName, schemaName);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

