/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.shardingsphere.infra.database.core.checker.DialectDatabasePrivilegeChecker;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.exception.TransactionTimeoutException;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;
import org.apache.shardingsphere.transaction.xa.jta.datasource.XATransactionDataSource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class XAShardingSphereTransactionManager
implements ShardingSphereDistributedTransactionManager {
    private final Map<String, XATransactionDataSource> cachedDataSources = new CaseInsensitiveMap();
    private XATransactionManagerProvider xaTransactionManagerProvider;

    public void init(Map<String, DatabaseType> databaseTypes, Map<String, DataSource> dataSources, String providerType) {
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            DatabaseTypedSPILoader.findService(DialectDatabasePrivilegeChecker.class, (DatabaseType)databaseTypes.get(entry.getKey())).ifPresent(optional -> optional.check((DataSource)entry.getValue(), PrivilegeCheckType.XA));
        }
        this.xaTransactionManagerProvider = (XATransactionManagerProvider)TypedSPILoader.getService(XATransactionManagerProvider.class, (Object)providerType);
        this.xaTransactionManagerProvider.init();
        Map<String, ResourceDataSource> resourceDataSources = this.getResourceDataSources(dataSources);
        resourceDataSources.forEach((key, value) -> this.cachedDataSources.put(value.getOriginalName(), this.newXATransactionDataSource((DatabaseType)databaseTypes.get(key), (ResourceDataSource)value)));
    }

    private Map<String, ResourceDataSource> getResourceDataSources(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, ResourceDataSource> result = new LinkedHashMap<String, ResourceDataSource>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.put(entry.getKey(), new ResourceDataSource(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private XATransactionDataSource newXATransactionDataSource(DatabaseType databaseType, ResourceDataSource resourceDataSource) {
        String resourceName = resourceDataSource.getUniqueResourceName();
        DataSource dataSource = resourceDataSource.getDataSource();
        return new XATransactionDataSource(databaseType, resourceName, dataSource, this.xaTransactionManagerProvider);
    }

    public TransactionType getTransactionType() {
        return TransactionType.XA;
    }

    public boolean isInTransaction() {
        return null != this.xaTransactionManagerProvider && 6 != this.xaTransactionManagerProvider.getTransactionManager().getStatus();
    }

    public Connection getConnection(String databaseName, String dataSourceName) throws SQLException {
        try {
            return this.cachedDataSources.get(databaseName + "." + dataSourceName).getConnection();
        }
        catch (RollbackException | SystemException ex) {
            throw new SQLException(ex);
        }
    }

    public void begin() {
        this.xaTransactionManagerProvider.getTransactionManager().begin();
    }

    public void begin(int timeout) {
        ShardingSpherePreconditions.checkState((timeout >= 0 ? 1 : 0) != 0, TransactionTimeoutException::new);
        TransactionManager transactionManager = this.xaTransactionManagerProvider.getTransactionManager();
        transactionManager.setTransactionTimeout(timeout);
        transactionManager.begin();
    }

    public void commit(boolean rollbackOnly) {
        if (rollbackOnly) {
            this.xaTransactionManagerProvider.getTransactionManager().rollback();
        } else {
            this.xaTransactionManagerProvider.getTransactionManager().commit();
        }
    }

    public void rollback() {
        this.xaTransactionManagerProvider.getTransactionManager().rollback();
    }

    public boolean containsProviderType(String providerType) {
        try {
            TypedSPILoader.checkService(XATransactionManagerProvider.class, (Object)providerType, (Properties)new Properties());
            return true;
        }
        catch (ServiceProviderNotFoundException ex) {
            return false;
        }
    }

    public void close() {
        for (XATransactionDataSource each : this.cachedDataSources.values()) {
            each.close();
        }
        this.cachedDataSources.clear();
        if (null != this.xaTransactionManagerProvider) {
            this.xaTransactionManagerProvider.close();
        }
    }

    public String getType() {
        return TransactionType.XA.name();
    }
}

