/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.util.YamlDatabaseConfigurationImportExecutor;

public final class MetaDataImportExecutor {
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlDatabaseConfigurationImportExecutor databaseConfigImportExecutor;
    private final ContextManager contextManager;

    public MetaDataImportExecutor(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.databaseConfigImportExecutor = new YamlDatabaseConfigurationImportExecutor(contextManager);
    }

    public void importClusterConfigurations(ExportedMetaData exportedMetaData) throws SQLException {
        Collection<YamlProxyDatabaseConfiguration> databaseConfigs = this.getYamlProxyDatabaseConfigurations(exportedMetaData);
        this.importServerConfiguration(exportedMetaData);
        this.importDatabaseConfigurations(databaseConfigs);
    }

    private void importServerConfiguration(ExportedMetaData exportedMetaData) throws SQLException {
        YamlProxyServerConfiguration yamlServerConfig = (YamlProxyServerConfiguration)YamlEngine.unmarshal((String)(exportedMetaData.getRules() + System.lineSeparator() + exportedMetaData.getProps()), YamlProxyServerConfiguration.class);
        if (null == yamlServerConfig) {
            return;
        }
        this.importGlobalRules(yamlServerConfig);
        this.importProps(yamlServerConfig);
    }

    private void importGlobalRules(YamlProxyServerConfiguration yamlServerConfig) throws SQLException {
        Collection rules = this.ruleConfigSwapperEngine.swapToRuleConfigurations(yamlServerConfig.getRules());
        for (RuleConfiguration each : rules) {
            this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterGlobalRuleConfiguration(each);
        }
    }

    private void importProps(YamlProxyServerConfiguration yamlServerConfig) throws SQLException {
        this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterProperties(yamlServerConfig.getProps());
    }

    private Collection<YamlProxyDatabaseConfiguration> getYamlProxyDatabaseConfigurations(ExportedMetaData exportedMetaData) {
        LinkedList<YamlProxyDatabaseConfiguration> result = new LinkedList<YamlProxyDatabaseConfiguration>();
        for (String each : exportedMetaData.getDatabases().values()) {
            result.add((YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((String)each, YamlProxyDatabaseConfiguration.class));
        }
        return result;
    }

    public void importDatabaseConfigurations(Collection<YamlProxyDatabaseConfiguration> databaseConfigs) throws SQLException {
        for (YamlProxyDatabaseConfiguration each : databaseConfigs) {
            this.databaseConfigImportExecutor.importDatabaseConfiguration(each);
        }
    }

    @Generated
    public MetaDataImportExecutor(YamlDatabaseConfigurationImportExecutor databaseConfigImportExecutor, ContextManager contextManager) {
        this.databaseConfigImportExecutor = databaseConfigImportExecutor;
        this.contextManager = contextManager;
    }
}

