/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.CreateDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.DropDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropDatabaseStatement;

public final class DatabaseOperateBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        return DatabaseOperateBackendHandlerFactory.createBackendHandler(sqlStatement, connectionSession);
    }

    private static ProxyBackendHandler createBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof CreateDatabaseStatement) {
            return new CreateDatabaseBackendHandler((CreateDatabaseStatement)sqlStatement);
        }
        if (sqlStatement instanceof DropDatabaseStatement) {
            return new DropDatabaseBackendHandler((DropDatabaseStatement)sqlStatement, connectionSession);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    @Generated
    private DatabaseOperateBackendHandlerFactory() {
    }
}

