/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.internal.annotation.JobAnnotationBuilder;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduler;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ScheduleJobBootstrap
implements JobBootstrap {
    private final JobScheduler jobScheduler;

    public ScheduleJobBootstrap(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig) {
        this.jobScheduler = new JobScheduler(regCenter, elasticJob, jobConfig);
    }

    public ScheduleJobBootstrap(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig) {
        this.jobScheduler = new JobScheduler(regCenter, elasticJobType, jobConfig);
    }

    public ScheduleJobBootstrap(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob) {
        JobConfiguration jobConfig = JobAnnotationBuilder.generateJobConfiguration(elasticJob.getClass());
        this.jobScheduler = new JobScheduler(regCenter, elasticJob, jobConfig);
    }

    public void schedule() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.jobScheduler.getJobConfig().getCron()) ? 1 : 0) != 0, (Object)"Cron can not be empty.");
        this.jobScheduler.getJobScheduleController().scheduleJob(this.jobScheduler.getJobConfig().getCron(), this.jobScheduler.getJobConfig().getTimeZone());
    }

    @Override
    public void shutdown() {
        this.jobScheduler.shutdown();
    }
}

