/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule.table;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLogicColumnNotFoundException;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.CipherColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class EncryptTable {
    private final String table;
    private final Map<String, EncryptColumn> columns;

    public EncryptTable(EncryptTableRuleConfiguration config, Map<String, EncryptAlgorithm> encryptors) {
        this.table = config.getName();
        this.columns = this.createEncryptColumns(config, encryptors);
    }

    private Map<String, EncryptColumn> createEncryptColumns(EncryptTableRuleConfiguration config, Map<String, EncryptAlgorithm> encryptors) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (EncryptColumnRuleConfiguration each : config.getColumns()) {
            result.put(each.getName(), this.createEncryptColumn(each, encryptors));
        }
        return result;
    }

    private EncryptColumn createEncryptColumn(EncryptColumnRuleConfiguration config, Map<String, EncryptAlgorithm> encryptors) {
        CipherColumnItem cipherColumnItem = new CipherColumnItem(config.getCipher().getName(), encryptors.get(config.getCipher().getEncryptorName()));
        EncryptColumn result = new EncryptColumn(config.getName(), cipherColumnItem);
        if (config.getAssistedQuery().isPresent()) {
            AssistedQueryColumnItem assistedQueryColumn = new AssistedQueryColumnItem(((EncryptColumnItemRuleConfiguration)config.getAssistedQuery().get()).getName(), encryptors.get(((EncryptColumnItemRuleConfiguration)config.getAssistedQuery().get()).getEncryptorName()));
            result.setAssistedQuery(assistedQueryColumn);
        }
        if (config.getLikeQuery().isPresent()) {
            LikeQueryColumnItem likeQueryColumn = new LikeQueryColumnItem(((EncryptColumnItemRuleConfiguration)config.getLikeQuery().get()).getName(), encryptors.get(((EncryptColumnItemRuleConfiguration)config.getLikeQuery().get()).getEncryptorName()));
            result.setLikeQuery(likeQueryColumn);
        }
        return result;
    }

    public Optional<EncryptAlgorithm> findEncryptor(String logicColumnName) {
        return this.columns.containsKey(logicColumnName) ? Optional.of(this.columns.get(logicColumnName).getCipher().getEncryptor()) : Optional.empty();
    }

    public boolean isEncryptColumn(String logicColumnName) {
        return this.columns.containsKey(logicColumnName);
    }

    public EncryptColumn getEncryptColumn(String logicColumnName) {
        ShardingSpherePreconditions.checkState((boolean)this.isEncryptColumn(logicColumnName), () -> new EncryptColumnNotFoundException(this.table, logicColumnName));
        return this.columns.get(logicColumnName);
    }

    public boolean isCipherColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> each.getCipher().getName().equalsIgnoreCase(columnName));
    }

    public String getLogicColumnByCipherColumn(String cipherColumnName) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getCipher().getName().equalsIgnoreCase(cipherColumnName)) continue;
            return entry.getValue().getName();
        }
        throw new EncryptLogicColumnNotFoundException(cipherColumnName);
    }

    public String getLogicColumnByAssistedQueryColumn(String assistQueryColumnName) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getAssistedQuery().isPresent() || !entry.getValue().getAssistedQuery().get().getName().equalsIgnoreCase(assistQueryColumnName)) continue;
            return entry.getValue().getName();
        }
        throw new EncryptLogicColumnNotFoundException(assistQueryColumnName);
    }

    public boolean isAssistedQueryColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> columnName.equalsIgnoreCase(each.getAssistedQuery().map(AssistedQueryColumnItem::getName).orElse(null)));
    }

    public boolean isLikeQueryColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> columnName.equalsIgnoreCase(each.getLikeQuery().map(LikeQueryColumnItem::getName).orElse(null)));
    }

    public Optional<EncryptAlgorithm> findQueryEncryptor(String columnName) {
        return this.isEncryptColumn(columnName) ? Optional.of(this.getEncryptColumn(columnName).getQueryEncryptor()) : Optional.empty();
    }

    @Generated
    public String getTable() {
        return this.table;
    }
}

