/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLEofPacket
extends MySQLPacket {
    public static final int HEADER = 254;
    private final int warnings;
    private final int statusFlags;

    public MySQLEofPacket(int statusFlags) {
        this(0, statusFlags);
    }

    public MySQLEofPacket(MySQLPacketPayload payload) {
        Preconditions.checkArgument((254 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL EOF packet must be `0xfe`.");
        this.warnings = payload.readInt2();
        this.statusFlags = payload.readInt2();
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeInt1(254);
        payload.writeInt2(this.warnings);
        payload.writeInt2(this.statusFlags);
    }

    @Generated
    public MySQLEofPacket(int warnings, int statusFlags) {
        this.warnings = warnings;
        this.statusFlags = statusFlags;
    }

    @Generated
    public int getWarnings() {
        return this.warnings;
    }

    @Generated
    public int getStatusFlags() {
        return this.statusFlags;
    }
}

