/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinlogEventType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.AbstractMySQLBinlogEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogTableMapEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinlogRowsEventPacket
extends AbstractMySQLBinlogEventPacket {
    private final long tableId;
    private final int flags;
    private final int columnNumber;
    private final MySQLNullBitmap columnsPresentBitmap;
    private final MySQLNullBitmap columnsPresentBitmap2;
    private final List<Serializable[]> rows = new LinkedList<Serializable[]>();
    private final List<Serializable[]> rows2 = new LinkedList<Serializable[]>();

    public MySQLBinlogRowsEventPacket(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        super(binlogEventHeader);
        this.tableId = payload.readInt6();
        this.flags = payload.readInt2();
        this.skipExtraData(payload);
        this.columnNumber = (int)payload.readIntLenenc();
        this.columnsPresentBitmap = new MySQLNullBitmap(this.columnNumber, payload);
        this.columnsPresentBitmap2 = this.readUpdateColumnsPresentBitmap(payload);
    }

    private void skipExtraData(MySQLPacketPayload payload) {
        if (this.isRowsEventVersion2(this.getBinlogEventHeader().getEventType())) {
            int extraDataLength = payload.readInt2() - 2;
            payload.skipReserved(extraDataLength);
        }
    }

    private boolean isRowsEventVersion2(int eventType) {
        return MySQLBinlogEventType.WRITE_ROWS_EVENT_V2.getValue() == eventType || MySQLBinlogEventType.UPDATE_ROWS_EVENT_V2.getValue() == eventType || MySQLBinlogEventType.DELETE_ROWS_EVENT_V2.getValue() == eventType;
    }

    private MySQLNullBitmap readUpdateColumnsPresentBitmap(MySQLPacketPayload payload) {
        return this.isUpdateRowsEvent(this.getBinlogEventHeader().getEventType()) ? new MySQLNullBitmap(this.columnNumber, payload) : null;
    }

    private boolean isUpdateRowsEvent(int eventType) {
        return MySQLBinlogEventType.UPDATE_ROWS_EVENT_V2.getValue() == eventType || MySQLBinlogEventType.UPDATE_ROWS_EVENT_V1.getValue() == eventType;
    }

    public void readRows(MySQLBinlogTableMapEventPacket tableMapEventPacket, MySQLPacketPayload payload) {
        List<MySQLBinlogColumnDef> columnDefs = tableMapEventPacket.getColumnDefs();
        while (this.getRemainBytesLength(payload) > 0) {
            this.rows.add(this.readRow(columnDefs, payload));
            if (!this.isUpdateRowsEvent(this.getBinlogEventHeader().getEventType())) continue;
            this.rows2.add(this.readRow(columnDefs, payload));
        }
    }

    private Serializable[] readRow(List<MySQLBinlogColumnDef> columnDefs, MySQLPacketPayload payload) {
        MySQLNullBitmap nullBitmap = new MySQLNullBitmap(this.columnNumber, payload);
        Serializable[] result = new Serializable[this.columnNumber];
        for (int i = 0; i < this.columnNumber; ++i) {
            MySQLBinlogColumnDef columnDef = columnDefs.get(i);
            result[i] = nullBitmap.isNullParameter(i) ? null : MySQLBinlogProtocolValueFactory.getBinlogProtocolValue(columnDef.getColumnType()).read(columnDef, payload);
        }
        return result;
    }

    @Override
    protected void writeEvent(MySQLPacketPayload payload) {
    }

    @Generated
    public long getTableId() {
        return this.tableId;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Generated
    public MySQLNullBitmap getColumnsPresentBitmap() {
        return this.columnsPresentBitmap;
    }

    @Generated
    public MySQLNullBitmap getColumnsPresentBitmap2() {
        return this.columnsPresentBitmap2;
    }

    @Generated
    public List<Serializable[]> getRows() {
        return this.rows;
    }

    @Generated
    public List<Serializable[]> getRows2() {
        return this.rows2;
    }
}

