/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum MySQLAuthenticationPlugin {
    DEFAULT(null),
    NATIVE("mysql_native_password"),
    CACHING_SHA2("caching_sha2_password"),
    SHA256("sha256_password");

    private static final Map<String, MySQLAuthenticationPlugin> VALUE_AND_COLUMN_TYPE_MAP;
    private final String pluginName;

    public static MySQLAuthenticationPlugin getPluginByName(String pluginName) {
        return VALUE_AND_COLUMN_TYPE_MAP.getOrDefault(pluginName, DEFAULT);
    }

    @Generated
    private MySQLAuthenticationPlugin(String pluginName) {
        this.pluginName = pluginName;
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    static {
        VALUE_AND_COLUMN_TYPE_MAP = new HashMap<String, MySQLAuthenticationPlugin>(MySQLAuthenticationPlugin.values().length, 1.0f);
        for (MySQLAuthenticationPlugin each : MySQLAuthenticationPlugin.values()) {
            VALUE_AND_COLUMN_TYPE_MAP.put(each.getPluginName(), each);
        }
    }
}

