/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowRulesStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShowShadowRuleExecutor
implements DistSQLQueryExecutor<ShowShadowRulesStatement>,
DistSQLExecutorRuleAware<ShadowRule> {
    private ShadowRule rule;

    public Collection<String> getColumnNames(ShowShadowRulesStatement sqlStatement) {
        return Arrays.asList("shadow_table", "rule_name", "source_name", "shadow_name", "algorithm_type", "algorithm_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShadowRulesStatement sqlStatement, ContextManager contextManager) {
        Map<String, Map<String, ShadowTableConfiguration>> dataSourceTableMap = this.convertToDataSourceTableMap(this.rule.getConfiguration().getTables());
        Collection specifiedConfigs = this.isSpecified(sqlStatement) ? (Collection)this.rule.getConfiguration().getDataSources().stream().filter(each -> each.getName().equalsIgnoreCase(sqlStatement.getRuleName())).collect(Collectors.toList()) : this.rule.getConfiguration().getDataSources();
        return specifiedConfigs.stream().map(each -> this.buildColumnData((ShadowDataSourceConfiguration)each, dataSourceTableMap, this.rule.getConfiguration().getShadowAlgorithms())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<String, Map<String, ShadowTableConfiguration>> convertToDataSourceTableMap(Map<String, ShadowTableConfiguration> tables) {
        Map<String, Map<String, ShadowTableConfiguration>> result = tables.values().stream().map(ShadowTableConfiguration::getDataSourceNames).flatMap(Collection::stream).distinct().collect(Collectors.toMap(each -> each, each -> new LinkedHashMap()));
        tables.forEach((key, value) -> value.getDataSourceNames().forEach(each -> ((Map)result.get(each)).put(key, value)));
        return result;
    }

    private boolean isSpecified(ShowShadowRulesStatement sqlStatement) {
        return null != sqlStatement.getRuleName() && !sqlStatement.getRuleName().isEmpty();
    }

    private Collection<LocalDataQueryResultRow> buildColumnData(ShadowDataSourceConfiguration dataSourceConfig, Map<String, Map<String, ShadowTableConfiguration>> dataSourceTableMap, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        Map<String, ShadowTableConfiguration> dataSourceTable = dataSourceTableMap.getOrDefault(dataSourceConfig.getName(), Collections.emptyMap());
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        dataSourceTable.forEach((key, value) -> value.getShadowAlgorithmNames().forEach(each -> {
            AlgorithmConfiguration algorithmConfig = (AlgorithmConfiguration)algorithmConfigs.get(each);
            result.add(new LocalDataQueryResultRow(new Object[]{key, dataSourceConfig.getName(), dataSourceConfig.getProductionDataSourceName(), dataSourceConfig.getShadowDataSourceName(), algorithmConfig.getType(), algorithmConfig.getProps()}));
        }));
        return result;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<ShowShadowRulesStatement> getType() {
        return ShowShadowRulesStatement.class;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

