/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.shadow.distsql.statement.ShowDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShowDefaultShadowAlgorithmExecutor
implements DistSQLQueryExecutor<ShowDefaultShadowAlgorithmStatement>,
DistSQLExecutorRuleAware<ShadowRule> {
    private ShadowRule rule;

    public Collection<String> getColumnNames(ShowDefaultShadowAlgorithmStatement sqlStatement) {
        return Arrays.asList("shadow_algorithm_name", "type", "props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowDefaultShadowAlgorithmStatement sqlStatement, ContextManager contextManager) {
        String defaultAlgorithm = this.rule.getConfiguration().getDefaultShadowAlgorithmName();
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (Map.Entry<String, AlgorithmConfiguration> entry : this.rule.getConfiguration().getShadowAlgorithms().entrySet().stream().filter(each -> ((String)each.getKey()).equals(defaultAlgorithm)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).entrySet()) {
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), entry.getValue().getType(), entry.getValue().getProps()}));
        }
        return result;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<ShowDefaultShadowAlgorithmStatement> getType() {
        return ShowDefaultShadowAlgorithmStatement.class;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

