/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.operator.common.SQLExtensionOperatorTable;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class MatchExpressionConverter {
    public static Optional<SqlNode> convert(MatchAgainstExpression segment) {
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnSegment each : segment.getColumns()) {
            if (each.getOwner().isPresent()) {
                MatchExpressionConverter.addOwnerNames(names, (OwnerSegment)each.getOwner().get());
            }
            names.add(each.getIdentifier().getValue());
        }
        sqlNodes.add(new SqlIdentifier(names, SqlParserPos.ZERO));
        ExpressionConverter.convert(segment.getExpr()).ifPresent(sqlNodes::add);
        SqlCharStringLiteral searchModifier = SqlLiteral.createCharString((String)segment.getSearchModifier(), (SqlParserPos)SqlParserPos.ZERO);
        sqlNodes.add(searchModifier);
        return Optional.of(new SqlBasicCall((SqlOperator)SQLExtensionOperatorTable.MATCH_AGAINST, sqlNodes, SqlParserPos.ZERO));
    }

    private static void addOwnerNames(List<String> names, OwnerSegment owner) {
        if (null != owner) {
            MatchExpressionConverter.addOwnerNames(names, owner.getOwner().orElse(null));
            names.add(owner.getIdentifier().getValue());
        }
    }

    @Generated
    private MatchExpressionConverter() {
    }
}

