/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.dml;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.common.ShardingSupportedCommonChecker;
import org.apache.shardingsphere.sharding.exception.syntax.InsertSelectTableViolationException;
import org.apache.shardingsphere.sharding.exception.syntax.MissingGenerateKeyColumnWithInsertSelectException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class ShardingInsertSupportedChecker
implements SupportedSQLChecker<InsertStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, InsertStatementContext sqlStatementContext) {
        InsertStatement insertStatement;
        Optional insertSelectSegment;
        if (null == sqlStatementContext.getInsertSelectContext()) {
            ShardingSupportedCommonChecker.checkMultipleTable(rule, (SQLStatementContext)sqlStatementContext);
        }
        if (!(insertSelectSegment = (insertStatement = sqlStatementContext.getSqlStatement()).getInsertSelect()).isPresent()) {
            return;
        }
        String tableName = insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        if (this.isContainsKeyGenerateStrategy(rule, tableName) && !this.isContainsKeyGenerateColumn(rule, insertStatement.getColumns(), tableName)) {
            throw new MissingGenerateKeyColumnWithInsertSelectException();
        }
        TablesContext tablesContext = sqlStatementContext.getTablesContext();
        if (rule.containsShardingTable(tablesContext.getTableNames()) && !this.isAllSameTables(tablesContext.getTableNames()) && !rule.isAllConfigBindingTables(tablesContext.getTableNames())) {
            throw new InsertSelectTableViolationException();
        }
    }

    private boolean isContainsKeyGenerateStrategy(ShardingRule shardingRule, String tableName) {
        return shardingRule.findGenerateKeyColumnName(tableName).isPresent();
    }

    private boolean isContainsKeyGenerateColumn(ShardingRule shardingRule, Collection<ColumnSegment> columns, String tableName) {
        return columns.isEmpty() || columns.stream().anyMatch(each -> shardingRule.isGenerateKeyColumn(each.getIdentifier().getValue(), tableName));
    }

    private boolean isAllSameTables(Collection<String> tableNames) {
        return 1L == tableNames.stream().distinct().count();
    }
}

